/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.PacketOnInfo;
import com.simba.server.components.data.SortInfo;
import java.sql.Timestamp;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class PlatInstance {
    private static final Logger logger = Logger.getLogger(PlatInstance.class);
    private Channel platClient;
    private final String platId;
    private int platMode;
    private int platStatus;
    private final ConcurrentHashMap<String, SortInfo> unDefinedSortInfos = new ConcurrentHashMap();
    private String workerNo;

    public PlatInstance(String toPlatId) {
        this.platId = toPlatId;
    }

    public Channel getPlatClient() {
        return this.platClient;
    }

    public String getPlatId() {
        return this.platId;
    }

    public int getPlatMode() {
        return this.platMode;
    }

    public int getPlatStatus() {
        return this.platStatus;
    }

    public String getWorkerNo() {
        return this.workerNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacketOnCommand(PacketOnInfo packetOnInfo) {
        SortInfo toDefineSortInfo = null;
        String toPlatId = packetOnInfo.getPlatId();
        String barcode = packetOnInfo.getBarcode();
        String carId = packetOnInfo.getCarId();
        String plcId = packetOnInfo.getPlcId();
        String platMode = packetOnInfo.getPlatMode();
        try {
            if (!this.platId.equalsIgnoreCase(toPlatId) || barcode == null) {
                return;
            }
            if (!this.unDefinedSortInfos.containsKey(barcode)) {
                return;
            }
            toDefineSortInfo = this.unDefinedSortInfos.get(barcode);
            toDefineSortInfo.setCarId(carId);
            toDefineSortInfo.setPlatMode(platMode);
            toDefineSortInfo.setPlatId(toPlatId);
            toDefineSortInfo.setPlcId(plcId);
            packetOnInfo.setScannedMode(toDefineSortInfo.getScannedMode());
            packetOnInfo.setScannedPlatType(toDefineSortInfo.getScannedPlatType());
            Timestamp packetOnTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            toDefineSortInfo.setTimestampPacketOn(packetOnTime);
            SortInfoManager.getInstance().addSortInfo(toDefineSortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle Packet On Message Error -- Exception : " + ex);
        }
        finally {
            if (this.unDefinedSortInfos.containsKey(barcode)) {
                this.unDefinedSortInfos.remove(barcode);
            }
        }
    }

    public SortInfo handleScannedCommand(Channel toPlatClient, JSONObject dataObj) {
        SortInfo unDefinedsortInfo = null;
        try {
            String toPlatId = dataObj.getString("platId");
            String barcode = dataObj.getString("barcode");
            String platMode = dataObj.getString("platMode");
            String scannedMode = dataObj.getString("scannedMode");
            String scannedPlatType = dataObj.getString("scannedPlatType");
            if (!this.platId.equalsIgnoreCase(toPlatId) || barcode == null) {
                return null;
            }
            if (toPlatClient != null && this.platClient != toPlatClient) {
                this.setPlatClient(toPlatClient);
            }
            unDefinedsortInfo = SortInfoManager.getInstance().createSortInfo();
            unDefinedsortInfo.setBarcode(barcode);
            unDefinedsortInfo.getBarcodeList().add(barcode);
            unDefinedsortInfo.setPlatId(toPlatId);
            unDefinedsortInfo.setPlatMode(platMode);
            unDefinedsortInfo.setScannedMode(scannedMode);
            unDefinedsortInfo.setScannedPlatType(scannedPlatType);
            Timestamp scannedTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            unDefinedsortInfo.setTimestampScanned(scannedTime);
            unDefinedsortInfo.setTimeScanned(scannedTime.toString());
            if (scannedPlatType.equals("MANUAL")) {
                String siteCode = dataObj.getString("siteCode");
                unDefinedsortInfo.setSiteCode(siteCode);
            }
            this.unDefinedSortInfos.put(barcode, unDefinedsortInfo);
            SortControllerManager.getInstance().onPlatScannedMessage(unDefinedsortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle Scanner Message With Simple Mode Error -- Exception : " + ex);
            unDefinedsortInfo = null;
        }
        return unDefinedsortInfo;
    }

    public void init() {
    }

    public void resetPlat() {
        try {
            this.unDefinedSortInfos.clear();
            this.sendResetMsgToPLC();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Reset Provide Plat Message Error -- Exception : " + ex);
        }
    }

    public void resetSelf() {
        this.unDefinedSortInfos.clear();
        this.sendResetMsgToPLC();
    }

    public void setPlatClient(Channel providePlatClient) {
        this.platClient = providePlatClient;
    }

    public void setPlatMode(int platMode) {
        this.platMode = platMode;
    }

    public void setPlatStatus(int platStatus) {
        this.platStatus = platStatus;
    }

    public void setWorkerNo(String workerNumber) {
        this.workerNo = workerNumber;
    }

    private void sendResetMsgToPLC() {
        Channel[] channels;
        int platIdValue = Integer.parseInt(this.platId);
        byte[] sendContent = SortProtocolCreator.getInstance().createResetPlatBuffer(platIdValue);
        for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(channel, sendContent, false);
        }
    }
}

