/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MachineParams {
    protected static final Logger logger = Logger.getLogger(MachineParams.class);
    private int clearMode;
    private int clearStopCircles;
    private int clearStopTime;
    private String localMode;
    private int maxLoopCircles;
    private int maxScanTimes;
    private int noreadWarn;
    private int pidaiCheckTime;
    private int pidaiInterval;
    private String runStatus;
    private int saveElecTime;
    private String serverId;
    private int serverNoDataTime;
    private int sorterSpeed;
    private int startWarnTime;

    public static MachineParams getInstance() {
        return MachineParamsHolder.INSTANCE;
    }

    private MachineParams() {
    }

    public int getClearMode() {
        return this.clearMode;
    }

    public int getClearStopCircles() {
        return this.clearStopCircles;
    }

    public int getClearStopTime() {
        return this.clearStopTime;
    }

    public String getLocalMode() {
        return this.localMode;
    }

    public int getMaxLoopCircles() {
        return this.maxLoopCircles;
    }

    public int getMaxScanTimes() {
        return this.maxScanTimes;
    }

    public int getNoreadWarn() {
        return this.noreadWarn;
    }

    public int getPidaiCheckTime() {
        return this.pidaiCheckTime;
    }

    public int getPidaiInterval() {
        return this.pidaiInterval;
    }

    public String getRunStatus() {
        return this.runStatus;
    }

    public int getSaveElecTime() {
        return this.saveElecTime;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getServerNoDataTime() {
        return this.serverNoDataTime;
    }

    public int getSorterSpeed() {
        return this.sorterSpeed;
    }

    public int getStartWarnTime() {
        return this.startWarnTime;
    }

    public void loadBasicConfig() {
        try {
            HashMap<String, String> configMap = new HashMap<String, String>();
            ICommand command = CommandCreator.getInstance().createCommand("FetchBasicConfigCmd", configMap);
            SQLCommandExecutor.getInstance().executeCmd(command);
            if (configMap != null && configMap.size() > 0) {
                this.setBasicConfigs(configMap);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SorterParameter.initSortParams] init sorter params error: " + ex, 2));
        }
    }

    public void setBasicConfigs(HashMap<String, String> configMap) {
        String localMode;
        String pidaiCheckTimeValue;
        String pidaiIntervalValue;
        String saveElecTimeValue;
        String noreadWarnValue;
        String clearStopCirclesValue;
        String clearStopTimeValue;
        String startWarnTimeValue;
        String sorterSpeedValue;
        String clearModeValue;
        String maxScanTimesValue;
        String maxLoopCirclesValue = configMap.get("maxTurnNumber");
        if (maxLoopCirclesValue != null) {
            try {
                this.maxLoopCircles = Integer.parseInt(maxLoopCirclesValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((maxScanTimesValue = configMap.get("maxScanNumber")) != null) {
            try {
                this.maxScanTimes = Integer.parseInt(maxScanTimesValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((clearModeValue = configMap.get("clearMode")) != null) {
            try {
                this.clearMode = Integer.parseInt(clearModeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((sorterSpeedValue = configMap.get("sorterSpeed")) != null) {
            try {
                this.sorterSpeed = Integer.parseInt(sorterSpeedValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((startWarnTimeValue = configMap.get("startWarnTime")) != null) {
            try {
                this.startWarnTime = Integer.parseInt(startWarnTimeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((clearStopTimeValue = configMap.get("clearStopTime")) != null) {
            try {
                this.clearStopTime = Integer.parseInt(clearStopTimeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((clearStopCirclesValue = configMap.get("clearStopCircles")) != null) {
            try {
                this.clearStopCircles = Integer.parseInt(clearStopCirclesValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((noreadWarnValue = configMap.get("noreadWarn")) != null) {
            try {
                this.noreadWarn = Integer.parseInt(noreadWarnValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((saveElecTimeValue = configMap.get("saveElecTime")) != null) {
            try {
                this.saveElecTime = Integer.parseInt(saveElecTimeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((pidaiIntervalValue = configMap.get("pidaiInterval")) != null) {
            try {
                this.setPidaiInterval(Integer.parseInt(pidaiIntervalValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((pidaiCheckTimeValue = configMap.get("pidaiCheckTime")) != null) {
            try {
                this.setPidaiCheckTime(Integer.parseInt(pidaiCheckTimeValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((localMode = configMap.get("localMode")) != null) {
            this.setLocalMode(localMode);
        } else {
            this.setLocalMode("false");
        }
    }

    public void setClearMode(int clearMode) {
        this.clearMode = clearMode;
    }

    public void setClearStopCircles(int clearStopCircles) {
        this.clearStopCircles = clearStopCircles;
    }

    public void setClearStopTime(int clearStopTime) {
        this.clearStopTime = clearStopTime;
    }

    public void setLocalMode(String localMode) {
        this.localMode = localMode;
    }

    public void setMaxScanTimes(int maxLoopTimes) {
        this.maxScanTimes = maxLoopTimes;
    }

    public void setNoreadWarn(int noreadWarn) {
        this.noreadWarn = noreadWarn;
    }

    public void setPidaiCheckTime(int pidaiCheckTime) {
        this.pidaiCheckTime = pidaiCheckTime;
    }

    public void setPidaiInterval(int pidaiInterval) {
        this.pidaiInterval = pidaiInterval;
    }

    public void setRunStatus(String runStatus) {
        this.runStatus = runStatus;
    }

    public void setSaveElecTime(int saveElecTime) {
        this.saveElecTime = saveElecTime;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setServerNoDataTime(int serverNoDataTime) {
        this.serverNoDataTime = serverNoDataTime;
    }

    public void setSorterSpeed(int sorterSpeed) {
        this.sorterSpeed = sorterSpeed;
    }

    public void setStartWarnTime(int startWarnTime) {
        this.startWarnTime = startWarnTime;
    }

    private static class MachineParamsHolder {
        private static MachineParams INSTANCE = new MachineParams();

        private MachineParamsHolder() {
        }
    }
}

