/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.SortInfo;
import org.apache.log4j.Logger;

public class BarcodeManager {
    protected static final Logger logger = Logger.getLogger(BarcodeManager.class);
    private final String boxRegex = "^[A-Z]{2}[A-Z0-9]{14,16}[0-9]{8}$";
    private final String packageRegex = "^([A-Z0-9]{8,})(-(?=\\d{1,3})|N(?=\\d{1,3}S))([1-9]\\d{0,2})(-(?=\\d{1,3}-)|S(?=\\d{1,3}H))([1-9]\\d{0,2})([-|H][A-Za-z0-9]*)$";
    private final String packageRegexNew = "^(JD[0-9A-GI-MO-RT-Z]{12}\\d)([-,N])([1-9][0-9]{0,5})([-,S])([0-9A-GI-MO-RT-Z]{1,6})([-,H]\\w{0,8})?$";
    private final String packageRegexCode = "^JD[0-9A-GI-MO-RT-Z]{12}\\d";
    private String webBoxRegex;
    private String webPackageRegex;

    public static BarcodeManager getInstance() {
        return BarcodeManagerHolder.INSTANCE;
    }

    public static void testmain(String[] args) {
    }

    private BarcodeManager() {
    }

    public Boolean checkBarcodeValid(String barcode) {
        Boolean ret = false;
        try {
            ret = barcode.matches(this.packageRegex);
            if (!ret.booleanValue() && !(ret = Boolean.valueOf(barcode.matches(this.packageRegexNew))).booleanValue()) {
                ret = barcode.matches(this.packageRegexCode);
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public Boolean checkBoxCodeValid(String boxCode) {
        Boolean ret = false;
        try {
            ret = boxCode.matches(this.boxRegex);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public void createSortInfoBarcodeList(SortInfo sortInfo) {
    }

    public String getWebBoxRegex() {
        return this.webBoxRegex;
    }

    public String getWebPackageRegex() {
        return this.webPackageRegex;
    }

    public void init() {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("WebBarRuleCmd", "boxCode");
            WebCommandExecutor.getInstance().executeCmd(command);
            command = CommandCreator.getInstance().createCommand("WebBarRuleCmd", "packageCode");
            WebCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[BarcodeManager.init] Catch an exception [" + ex.getMessage() + "]");
        }
    }

    public void setWebBoxRegex(String webBoxRegex) {
        this.webBoxRegex = webBoxRegex;
    }

    public void setWebPackageRegex(String webPackageRegex) {
        this.webPackageRegex = webPackageRegex;
    }

    private static class BarcodeManagerHolder {
        private static final BarcodeManager INSTANCE = new BarcodeManager();

        private BarcodeManagerHolder() {
        }
    }
}

