/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.SortPlanItem;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebSortPlanCmd
implements ICommand {
    public static final String NAME = "WebSortPlanCmd";
    private static final Logger logger = Logger.getLogger(WebSortPlanCmd.class);
    private final List<SortPlanItem> sortPlanItems;

    public WebSortPlanCmd(List<SortPlanItem> sortPlanItems) {
        this.sortPlanItems = sortPlanItems;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (this.sortPlanItems == null) {
            return ret;
        }
        this.sortPlanItems.clear();
        String urlPostFix = "/services/sortScheme/getSortSchemeByMachineCode/";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix + SorterParams.getInstance().getMachineCode();
        HttpGet sortPlanRequest = new HttpGet(url);
        CloseableHttpResponse response = null;
        String content = "None";
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByGet(sortPlanRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            int status = responseObj.getInt("code");
            JSONObject dataObj = responseObj.getJSONObject("data");
            if (status == 200) {
                ret = this.parseSortPlan(dataObj);
                if (!ret.booleanValue()) {
                    this.sortPlanItems.clear();
                }
            } else {
                ret = false;
            }
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "Catch IO Exception when request sort plan info , Response Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Catch Unknown Exception when request sort plan info , Response Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }

    private Boolean parseSortPlan(JSONObject responseObj) {
        String name = responseObj.getString("name");
        int planId = responseObj.getInt("id");
        String currName = SorterParams.getInstance().getSortPlanName();
        int currPlanId = SorterParams.getInstance().getSortPlanId();
        if (name.equals(currName) && currPlanId == planId) {
            return true;
        }
        SorterParams.getInstance().setSortPlanName(name);
        SorterParams.getInstance().setSortPlanId(planId);
        String machineCode = responseObj.getString("machineCode");
        String siteName = responseObj.getString("siteName");
        String sortMode = responseObj.getString("sortMode");
        String siteNo = responseObj.getString("siteNo");
        int recvFlag = responseObj.getInt("receFlag");
        int ynFlag = responseObj.getInt("yn");
        JSONArray sortPlanItems = responseObj.getJSONArray("sortSchemeDetailList");
        int sortPlanItemLen = sortPlanItems.length();
        for (int i = 0; i < sortPlanItemLen; ++i) {
            JSONObject itemObj = sortPlanItems.getJSONObject(i);
            int itemId = itemObj.getInt("id");
            String pkgLableName = itemObj.getString("pkgLabelName");
            String boxSiteCode = itemObj.getString("boxSiteCode");
            String currChuteCode = itemObj.getString("currChuteCode");
            String siteCode = itemObj.getString("siteCode");
            String subType = itemObj.getString("subType");
            String chuteCode1 = itemObj.getString("chuteCode1");
            SortPlanItem sortPlanItem = new SortPlanItem();
            sortPlanItem.setName(name);
            sortPlanItem.setPlanId(planId);
            sortPlanItem.setMachineCode(machineCode);
            sortPlanItem.setSiteName(siteName);
            sortPlanItem.setSortMode(sortMode);
            sortPlanItem.setSiteNo(siteNo);
            sortPlanItem.setRecvFlag(recvFlag);
            sortPlanItem.setYnFlag(ynFlag);
            sortPlanItem.setItemId(itemId);
            sortPlanItem.setPkgLabelName(pkgLableName);
            sortPlanItem.setBoxSiteCode(boxSiteCode);
            sortPlanItem.setCurrChuteCode(currChuteCode);
            sortPlanItem.setSiteCode(siteCode);
            sortPlanItem.setSubType(subType);
            sortPlanItem.setChuteCode1(chuteCode1);
            this.sortPlanItems.add(sortPlanItem);
        }
        return true;
    }
}

