/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.SortInfo;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebSortInfoCmd
implements ICommand {
    public static final String NAME = "WebSortInfoCmd";
    private static final Logger logger = Logger.getLogger(WebSortInfoCmd.class);
    private final SortInfo sortInfo;

    public WebSortInfoCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/services/smartDistribution/getWaybillChute";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createSortInfo(this.sortInfo);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            if (!responseObj.has("code") || responseObj.isNull("code")) {
                this.sortInfo.setErrorCodeSVR(12);
            } else {
                this.handleWithReturnCode(responseObj);
            }
            ret = true;
            LogUtil.LogDebug(logger, "[WebSortInfoCmd] Response Content:[" + content + "] Response Content:[" + responseObj.toString() + "]");
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "Catch IO Exception when request sort info , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            this.sortInfo.setErrorCodeSVR(11);
            ret = false;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Catch Unkown Exception when request sort info , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            this.sortInfo.setErrorCodeSVR(9);
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }

    private int getChuteCodes(JSONObject responseObj) {
        int errorCode = 0;
        JSONArray chuteCodeArray = responseObj.getJSONArray("chuteCode");
        int chuteCodelength = chuteCodeArray.length();
        if (chuteCodelength > 0) {
            this.sortInfo.getSlotsList().clear();
            this.sortInfo.getChuteCodeList().clear();
        }
        for (int i = 0; i < chuteCodelength; ++i) {
            String slotId = chuteCodeArray.getString(i);
            this.sortInfo.getSlotsList().add(Integer.parseInt(slotId));
            this.sortInfo.getChuteCodeList().add(slotId);
        }
        return errorCode;
    }

    private int getSiteCode(JSONObject responseObj) {
        int errorCode = 0;
        JSONArray siteCodeArray = responseObj.getJSONArray("siteCode");
        int siteCodelength = siteCodeArray.length();
        if (siteCodelength > 0) {
            String siteCode = siteCodeArray.getString(0);
            this.sortInfo.setSiteCode(siteCode);
            if (siteCode.equals("EXP120")) {
                errorCode = 15;
            } else if (siteCode.equals("EXP130")) {
                errorCode = 16;
            }
        }
        for (int i = 0; i < siteCodelength; ++i) {
            this.sortInfo.getSiteCodeList().add(siteCodeArray.getString(i));
        }
        return errorCode;
    }

    private void handleWithReturnCode(JSONObject responseObj) {
        int errorCode = 0;
        int code = responseObj.getInt("code");
        this.sortInfo.setWebJDCode(code);
        if (code == 200) {
            if (responseObj.has("chuteCode") && !responseObj.isNull("chuteCode")) {
                errorCode = this.getChuteCodes(responseObj);
            } else {
                errorCode = 13;
                this.sortInfo.setErrorCodeSVR(errorCode);
                this.sortInfo.getSlotsList().clear();
                this.sortInfo.getChuteCodeList().clear();
            }
            if (responseObj.has("siteCode") && !responseObj.isNull("siteCode")) {
                errorCode = this.getSiteCode(responseObj);
            } else {
                errorCode = 14;
                this.sortInfo.setErrorCodeSVR(errorCode);
                this.sortInfo.setSiteCode("No-Site-Code");
            }
            if (responseObj.has("sortMode") && !responseObj.isNull("sortMode")) {
                String sortMode = responseObj.getString("sortMode");
                this.sortInfo.setSortMode(sortMode);
            } else {
                this.sortInfo.setSortMode("1");
            }
        } else {
            switch (code) {
                case 401: {
                    errorCode = 1;
                    break;
                }
                case 402: {
                    errorCode = 2;
                    break;
                }
                case 500: {
                    errorCode = 9;
                    break;
                }
                case 1000: {
                    errorCode = 10;
                    break;
                }
            }
        }
        this.sortInfo.setErrorCodeSVR(errorCode);
    }
}

