/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.SlotInfo;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebBoxInfoCmd
implements ICommand {
    public static final String NAME = "WebBoxInfoCmd";
    private static final Logger logger = Logger.getLogger(WebBoxInfoCmd.class);
    private final SlotInfo slotInfo;

    public WebBoxInfoCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/services/smartDistribution/smartBoxes";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        if (!SorterParams.getInstance().isNeedBoxInfo()) {
            serverHost = SorterParams.getInstance().getDebugServerHost();
            serverPort = SorterParams.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createBoxInfoContent(this.slotInfo);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            int status = responseObj.getInt("code");
            if (status == 200) {
                ret = this.parseBoxInfos(responseObj);
                if (ret.booleanValue()) {
                    this.printSlotBoxAllocInfo();
                }
            } else {
                this.printSlotBoxAllocFailed(status);
                ret = false;
            }
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "Catch IO Exception when request box info , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }

    private Boolean parseBoxInfos(JSONObject responseObj) {
        Boolean ret = false;
        String slotId = this.slotInfo.getSlotId();
        String chuteCode = this.slotInfo.getChuteCode();
        BoxInfo boxInfo = this.slotInfo.getBoxInfo();
        if (responseObj.has("boxCodes")) {
            try {
                JSONArray boxInfoArray = responseObj.getJSONArray("boxCodes");
                int len = boxInfoArray.length();
                if (len <= 0) {
                    return null;
                }
                JSONObject boxObj = boxInfoArray.getJSONObject(0);
                String boxCode = boxObj.getString("boxCode");
                boxInfo.setBoxCode(boxCode);
                String boxType = boxObj.getString("boxType");
                boxInfo.setBoxType(boxType);
                String recieveSiteCode = String.valueOf(boxObj.getInt("receiveSiteCode"));
                boxInfo.setReceiveSiteCode(recieveSiteCode);
                String receiveSiteName = boxObj.getString("receiveSiteName");
                boxInfo.setReceiveSiteName(receiveSiteName);
                String createSiteName = boxObj.getString("createSiteName");
                boxInfo.setCreateSiteName(createSiteName);
                String categoryText = boxObj.getString("categoryText");
                boxInfo.setCategoryText(categoryText);
                String mixBoxTypeText = boxObj.getString("mixBoxTypeText");
                boxInfo.setMixBoxTypeText(mixBoxTypeText);
                JSONArray routers = boxObj.getJSONArray("router");
                String routersContent = routers.toString();
                boxInfo.setRouter(routersContent);
                String routerNum = boxObj.getString("routerNum");
                boxInfo.setRouterNum(routerNum);
                boxInfo.setSlotId(slotId);
                boxInfo.setChuteCode(chuteCode);
                ret = true;
            }
            catch (Exception ex) {
                LogUtil.LogError(logger, "Catch an exception when parse box info content :" + ex.getMessage());
                ret = false;
            }
        }
        return ret;
    }

    private void printSlotBoxAllocFailed(int status) {
        StringBuilder boxInfoBuilder = new StringBuilder(50);
        boxInfoBuilder.append("Slot:[");
        boxInfoBuilder.append(this.slotInfo.getChuteCode());
        boxInfoBuilder.append("],Alloc Box Code Failed:[");
        boxInfoBuilder.append(status);
        boxInfoBuilder.append("]");
        LogUtil.LogDebug(logger, boxInfoBuilder.toString());
    }

    private void printSlotBoxAllocInfo() {
        StringBuilder boxInfoBuilder = new StringBuilder(50);
        boxInfoBuilder.append("Slot:[");
        boxInfoBuilder.append(this.slotInfo.getChuteCode());
        boxInfoBuilder.append("],Alloc Box Code:[");
        boxInfoBuilder.append(this.slotInfo.getBoxInfo().getBoxCode());
        boxInfoBuilder.append("]");
        LogUtil.LogDebug(logger, boxInfoBuilder.toString());
    }
}

