/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.SlotInfo;

public class RecordBoxPackCmd
implements ICommand {
    public static final String NAME = "RecordBoxPackCmd";
    private final BoxInfo boxInfo;
    private final SlotInfo slotInfo;
    private final String sql = "insert into tt_slot_pack_info(slotId, chuteCode, boxCode, boxType, createTime, mailCount, router, routerNum,receiveSiteCode,receiveSiteName,createSiteName,categoryText,mixBoxTypeText,printerMaster,printerSlave) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

    public RecordBoxPackCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
        this.boxInfo = this.slotInfo.getBoxInfo();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String slotId = this.boxInfo.getSlotId();
            if (slotId == null || slotId.equals("")) {
                slotId = "none";
            }
            dbOperator.setString(1, slotId);
            String chuteCode = this.boxInfo.getChuteCode();
            if (chuteCode == null || chuteCode.equals("")) {
                chuteCode = "none";
            }
            dbOperator.setString(2, chuteCode);
            String boxCode = this.boxInfo.getBoxCode();
            if (boxCode == null || boxCode.equals("")) {
                boxCode = "none";
            }
            dbOperator.setString(3, boxCode);
            String boxType = this.boxInfo.getBoxType();
            if (boxType == null || boxType.equals("")) {
                boxType = "none";
            }
            dbOperator.setString(4, boxType);
            String createTime = this.boxInfo.getCreateTime();
            if (createTime == null || createTime.equals("")) {
                createTime = "none";
            }
            dbOperator.setString(5, createTime);
            dbOperator.setInt(6, this.boxInfo.getMailCount());
            String router = this.boxInfo.getRouter();
            if (router == null || router.equals("")) {
                router = "none";
            }
            dbOperator.setString(7, router);
            String routerNum = this.boxInfo.getRouterNum();
            if (routerNum == null || routerNum.equals("")) {
                routerNum = "none";
            }
            dbOperator.setString(8, routerNum);
            String receiveSiteCode = this.boxInfo.getReceiveSiteCode();
            if (receiveSiteCode == null || receiveSiteCode.equals("")) {
                receiveSiteCode = "none";
            }
            dbOperator.setString(9, receiveSiteCode);
            String receiveSiteName = this.boxInfo.getReceiveSiteName();
            if (receiveSiteName == null || receiveSiteName.equals("")) {
                receiveSiteName = "none";
            }
            dbOperator.setString(10, receiveSiteName);
            String createSiteName = this.boxInfo.getCreateSiteName();
            if (createSiteName == null || createSiteName.equals("")) {
                createSiteName = "none";
            }
            dbOperator.setString(11, createSiteName);
            String categoryText = this.boxInfo.getCategoryText();
            if (categoryText == null || categoryText.equals("")) {
                categoryText = "none";
            }
            dbOperator.setString(12, categoryText);
            String mixBoxTypeText = this.boxInfo.getMixBoxTypeText();
            if (mixBoxTypeText == null || mixBoxTypeText.equals("")) {
                mixBoxTypeText = "none";
            }
            dbOperator.setString(13, mixBoxTypeText);
            String masterPrinterIp = this.slotInfo.getMasterPrinterIp();
            if (masterPrinterIp == null || masterPrinterIp.equals("")) {
                masterPrinterIp = "none";
            }
            dbOperator.setString(14, masterPrinterIp);
            String slavePrinterIp = this.slotInfo.getSlavePrinterIp();
            if (slavePrinterIp == null || slavePrinterIp.equals("")) {
                slavePrinterIp = "none";
            }
            dbOperator.setString(15, slavePrinterIp);
            int res = dbOperator.executeUpdate();
            ret = res > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

