/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.processor;

import com.simba.common.ChannelManager;
import com.simba.common.RequestHandler;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.processor.BaseProcessor;
import com.simba.common.processor.ProcessorAttachInfo;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class WebSocketProcessor
extends BaseProcessor {
    private final ChannelManager channelManager;
    private final RequestHandler serviceHandler;

    public WebSocketProcessor(RequestHandler requestHandler, ChannelManager chManager) {
        this.serviceHandler = requestHandler;
        this.channelManager = chManager;
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    @Override
    public void onChannelConnected(Channel channel) throws Exception {
        this.addChannel(channel);
        this.logOnChannelConnected(channel);
    }

    @Override
    public void onChannelDisconnected(Channel channel) throws Exception {
        this.removeChannel(channel);
        this.logOnChannelDisconnected(channel);
    }

    @Override
    public void onChannelIdle(Channel channel, IdleStateEvent e) throws Exception {
    }

    @Override
    public void onExceptionCaught(Channel channel, Throwable cause) throws Exception {
    }

    @Override
    public void onMessageReceived(Channel channel, Object message) throws Exception {
        if (message != null && message instanceof WebSocketFrame) {
            WebSocketFrame request = (WebSocketFrame)message;
            this.serviceHandler.handleRequest(channel, request);
        }
    }

    @Override
    public void onWriteComplete(Channel channel) throws Exception {
    }

    @Override
    protected void addChannel(Channel channel) {
        long connectedTime = System.currentTimeMillis();
        ProcessorAttachInfo attachInfo = new ProcessorAttachInfo();
        attachInfo.setConnectedTime(connectedTime);
        attachInfo.setProcessorType("WebSockProcessor");
        channel.setAttachment(attachInfo);
        this.channelManager.addChannel(channel);
    }

    @Override
    protected void logOnChannelConnected(Channel channel) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(BaseProcessor.LOG), "[WebSocketProcessor.logOnChannelConnected] Connection opened [" + channel.getRemoteAddress() + "], Current WebSocket connection count is : " + String.valueOf(this.channelManager.getChannelCount()), 3));
    }

    @Override
    protected void logOnChannelDisconnected(Channel channel) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(BaseProcessor.LOG), "[WebSocketProcessor.logOnChannelDisconnected] Connection Closed [" + channel.getRemoteAddress() + "], Current WebSocket connection count is : " + String.valueOf(this.channelManager.getChannelCount()), 3));
    }

    @Override
    protected void removeChannel(Channel channel) {
        String id = String.valueOf(channel.getId());
        this.channelManager.removeChannel(id);
    }
}

