/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.processor;

import com.simba.common.ChannelManager;
import com.simba.common.RequestHandler;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.processor.BaseProcessor;
import com.simba.common.processor.ProcessorAttachInfo;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class DelimiterProcessor
extends BaseProcessor {
    private final ChannelManager channelManager;
    private final RequestHandler serviceHandler;

    public DelimiterProcessor(RequestHandler requestHandler, ChannelManager chManager) {
        this.serviceHandler = requestHandler;
        this.channelManager = chManager;
    }

    @Override
    public void onChannelConnected(Channel channel) throws Exception {
        long connectedTime = System.currentTimeMillis();
        ProcessorAttachInfo attachInfo = new ProcessorAttachInfo();
        attachInfo.setConnectedTime(connectedTime);
        attachInfo.setProcessorType("DelimiterProcessor");
        channel.setAttachment(attachInfo);
        this.addChannel(channel);
    }

    @Override
    public void onChannelDisconnected(Channel channel) throws Exception {
        this.removeChannel(channel);
        this.logOnChannelDisconnected(channel);
    }

    @Override
    public void onChannelIdle(Channel channel, IdleStateEvent cause) throws Exception {
        if (!channel.isConnected()) {
            this.removeChannel(channel);
        }
    }

    @Override
    public void onExceptionCaught(Channel channel, Throwable cause) throws Exception {
    }

    @Override
    public void onMessageReceived(Channel channel, Object message) throws Exception {
        byte[] contentMsg = (byte[])message;
        this.logOnMessageReceived(channel, contentMsg);
        this.serviceHandler.handleRequest(channel, contentMsg);
    }

    @Override
    public void onWriteComplete(Channel channel) throws Exception {
    }

    @Override
    protected void addChannel(Channel channel) {
        this.channelManager.addChannel(channel);
        this.logOnChannelConnected(channel);
    }

    @Override
    protected void logOnChannelConnected(Channel channel) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(BaseProcessor.LOG), "[DelimiterProcessor.logOnChannelConnected] Connection opened [" + channel.getRemoteAddress() + "], Current delimiter connection count is : " + String.valueOf(this.channelManager.getChannelCount()), 3));
    }

    @Override
    protected void removeChannel(Channel channel) {
        try {
            String key = String.valueOf(channel.getId());
            this.channelManager.removeChannel(key);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(BaseProcessor.LOG), "[JsonProcessor.removeChannel] Remove Json Service Channel Error -- Exception : " + ex.getMessage(), 2));
        }
    }
}

