/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.jsonserver;

import com.simba.GlobalParam;
import com.simba.common.ChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public class JsonChannelManager
implements ChannelManager {
    protected static final Logger logger = Logger.getLogger(JsonChannelManager.class);
    private final ConcurrentHashMap<String, Channel> channelList = new ConcurrentHashMap();

    public static JsonChannelManager getInstance() {
        return JsonChannelManagerHolder.INSTANCE;
    }

    private JsonChannelManager() {
    }

    @Override
    public void addChannel(Channel channel) {
        if (channel != null) {
            this.channelList.put(String.valueOf(channel.getId()), channel);
        }
    }

    @Override
    public void clearChannelList() {
        this.channelList.clear();
    }

    @Override
    public ChannelFuture commitResponse(Channel channel, Object response, boolean close) {
        ChannelFuture writeFuture = null;
        try {
            if (!(response instanceof byte[])) {
                return null;
            }
            byte[] msg = (byte[])response;
            int limit = msg.length;
            ByteBuffer returnBuffer = ByteBuffer.allocate(limit);
            returnBuffer.put(msg, 0, limit);
            returnBuffer.rewind();
            ChannelBuffer duplicateBuffer = ChannelBuffers.wrappedBuffer(returnBuffer);
            writeFuture = channel.write(duplicateBuffer);
            if (this.isNeedClose(response, close)) {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception ex) {
            if (GlobalParam.LOG_MODE != 3) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[JsonChannelManager.commitResponse] Message sent [" + channel.getRemoteAddress() + "] error -- " + ex.getMessage(), 3));
            }
            writeFuture = null;
        }
        return writeFuture;
    }

    @Override
    public boolean containsChannel(String key) {
        return this.channelList.containsKey(key);
    }

    @Override
    public Channel getChannel(String key) {
        return this.channelList.get(key.toLowerCase());
    }

    @Override
    public int getChannelCount() {
        return this.channelList.size();
    }

    @Override
    public Channel[] getChannelList() {
        return this.channelList.values().toArray(new Channel[0]);
    }

    @Override
    public boolean isNeedClose(Object response, boolean close) {
        return close;
    }

    @Override
    public Channel removeChannel(String key) {
        Channel tmpChannel = null;
        tmpChannel = this.channelList.remove(key);
        return tmpChannel;
    }

    private static class JsonChannelManagerHolder {
        private static final JsonChannelManager INSTANCE = new JsonChannelManager();

        private JsonChannelManagerHolder() {
        }
    }
}

