/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.httpserver;

import com.simba.common.processor.MessageProcessor;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class HttpChannelHandler
extends IdleStateAwareChannelHandler {
    protected MessageProcessor messageProcessor;

    public HttpChannelHandler(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel connection = this.getChannel(ctx);
        if (connection != null) {
            this.messageProcessor.onChannelConnected(connection);
        }
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel connection = this.getChannel(ctx);
        if (connection != null) {
            this.messageProcessor.onChannelDisconnected(connection);
        } else {
            e.getChannel().close();
        }
    }

    @Override
    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        Channel connection = this.getChannel(ctx);
        if (connection != null) {
            this.messageProcessor.onChannelIdle(connection, e);
        } else {
            e.getChannel().close();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel connection = this.getChannel(ctx);
        if (connection != null) {
            this.messageProcessor.onExceptionCaught(connection, e.getCause());
        } else {
            e.getChannel().close();
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Channel connection = this.getChannel(ctx);
        if (connection != null) {
            this.messageProcessor.onMessageReceived(connection, e.getMessage());
        }
    }

    @Override
    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        Channel connection = this.getChannel(ctx);
        if (connection != null) {
            this.messageProcessor.onWriteComplete(connection);
        }
    }

    protected Channel getChannel(ChannelHandlerContext ctx) {
        Channel channel = ctx.getChannel();
        return channel;
    }
}

