/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.frameserver.netty;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

public class OctBFrameDecoder
extends FrameDecoder {
    private long bytesToDiscard;
    private boolean discardingTooLongFrame;
    private final boolean failFast;
    private final int initialBytesToStrip;
    private final int lengthAdjustment;
    private final int lengthFieldEndOffset;
    private final int lengthFieldLength;
    private final int lengthFieldOffset;
    private final int maxFrameLength;
    private long tooLongFrameLength;

    public OctBFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength) {
        this(maxFrameLength, lengthFieldOffset, lengthFieldLength, 0, 0);
    }

    public OctBFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip) {
        this(maxFrameLength, lengthFieldOffset, lengthFieldLength, lengthAdjustment, initialBytesToStrip, false);
    }

    public OctBFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip, boolean failFast) {
        if (maxFrameLength <= 0) {
            throw new IllegalArgumentException("maxFrameLength must be a positive integer: " + maxFrameLength);
        }
        if (lengthFieldOffset < 0) {
            throw new IllegalArgumentException("lengthFieldOffset must be a non-negative integer: " + lengthFieldOffset);
        }
        if (initialBytesToStrip < 0) {
            throw new IllegalArgumentException("initialBytesToStrip must be a non-negative integer: " + initialBytesToStrip);
        }
        if (lengthFieldLength != 1 && lengthFieldLength != 2 && lengthFieldLength != 3 && lengthFieldLength != 4 && lengthFieldLength != 8) {
            throw new IllegalArgumentException("lengthFieldLength must be either 1, 2, 3, 4, or 8: " + lengthFieldLength);
        }
        if (lengthFieldOffset > maxFrameLength - lengthFieldLength) {
            throw new IllegalArgumentException("maxFrameLength (" + maxFrameLength + ") must be equal to or greater than lengthFieldOffset (" + lengthFieldOffset + ") + lengthFieldLength (" + lengthFieldLength + ").");
        }
        this.maxFrameLength = maxFrameLength;
        this.lengthFieldOffset = lengthFieldOffset;
        this.lengthFieldLength = lengthFieldLength;
        this.lengthAdjustment = lengthAdjustment;
        this.lengthFieldEndOffset = lengthFieldOffset + lengthFieldLength;
        this.initialBytesToStrip = initialBytesToStrip;
        this.failFast = failFast;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        long frameLength;
        if (this.discardingTooLongFrame) {
            long bytesToDiscard = this.bytesToDiscard;
            int localBytesToDiscard = (int)Math.min(bytesToDiscard, (long)buffer.readableBytes());
            buffer.skipBytes(localBytesToDiscard);
            this.bytesToDiscard = bytesToDiscard -= (long)localBytesToDiscard;
            this.failIfNecessary(ctx, false);
            return null;
        }
        if (buffer.readableBytes() < this.lengthFieldEndOffset) {
            return null;
        }
        int actualLengthFieldOffset = buffer.readerIndex() + this.lengthFieldOffset;
        switch (this.lengthFieldLength) {
            case 1: {
                frameLength = buffer.getUnsignedByte(actualLengthFieldOffset);
                break;
            }
            case 2: {
                frameLength = buffer.getUnsignedShort(actualLengthFieldOffset);
                break;
            }
            case 3: {
                frameLength = buffer.getUnsignedMedium(actualLengthFieldOffset);
                break;
            }
            case 4: {
                frameLength = buffer.getUnsignedInt(actualLengthFieldOffset);
                break;
            }
            case 8: {
                frameLength = this.getOctLen(buffer, actualLengthFieldOffset);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (frameLength < 0L) {
            buffer.skipBytes(this.lengthFieldEndOffset);
            throw new CorruptedFrameException("negative pre-adjustment length field: " + frameLength);
        }
        if ((frameLength += (long)(this.lengthAdjustment + this.lengthFieldEndOffset)) < (long)this.lengthFieldEndOffset) {
            buffer.skipBytes(this.lengthFieldEndOffset);
            throw new CorruptedFrameException("Adjusted frame length (" + frameLength + ") is less than lengthFieldEndOffset: " + this.lengthFieldEndOffset);
        }
        if (frameLength > (long)this.maxFrameLength) {
            this.discardingTooLongFrame = true;
            this.tooLongFrameLength = frameLength;
            this.bytesToDiscard = frameLength - (long)buffer.readableBytes();
            buffer.skipBytes(buffer.readableBytes());
            this.failIfNecessary(ctx, true);
            return null;
        }
        int frameLengthInt = (int)frameLength;
        if (buffer.readableBytes() < frameLengthInt) {
            return null;
        }
        if (this.initialBytesToStrip > frameLengthInt) {
            buffer.skipBytes(frameLengthInt);
            throw new CorruptedFrameException("Adjusted frame length (" + frameLength + ") is less than initialBytesToStrip: " + this.initialBytesToStrip);
        }
        buffer.skipBytes(this.initialBytesToStrip);
        int readerIndex = buffer.readerIndex();
        int actualFrameLength = frameLengthInt - this.initialBytesToStrip;
        ChannelBuffer frame = this.extractFrame(buffer, readerIndex, actualFrameLength);
        buffer.readerIndex(readerIndex + actualFrameLength);
        return frame;
    }

    private void fail(ChannelHandlerContext ctx, long frameLength) {
        if (frameLength > 0L) {
            Channels.fireExceptionCaught(ctx.getChannel(), (Throwable)new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + ": " + frameLength + " - discarded"));
        } else {
            Channels.fireExceptionCaught(ctx.getChannel(), (Throwable)new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + " - discarding"));
        }
    }

    private void failIfNecessary(ChannelHandlerContext ctx, boolean firstDetectionOfTooLongFrame) {
        if (this.bytesToDiscard == 0L) {
            long tooLongFrameLength = this.tooLongFrameLength;
            this.tooLongFrameLength = 0L;
            this.discardingTooLongFrame = false;
            if (!this.failFast || this.failFast && firstDetectionOfTooLongFrame) {
                this.fail(ctx, tooLongFrameLength);
            }
        } else if (this.failFast && firstDetectionOfTooLongFrame) {
            this.fail(ctx, this.tooLongFrameLength);
        }
    }

    private long getOctLen(ChannelBuffer buffer, int actualLengthFieldOffset) {
        int index = actualLengthFieldOffset;
        int len8 = (buffer.getByte(index) - 48) * 10000000;
        int len7 = (buffer.getByte(index + 1) - 48) * 1000000;
        int len6 = (buffer.getByte(index + 2) - 48) * 100000;
        int len5 = (buffer.getByte(index + 3) - 48) * 10000;
        int len4 = (buffer.getByte(index + 4) - 48) * 1000;
        int len3 = (buffer.getByte(index + 5) - 48) * 100;
        int len2 = (buffer.getByte(index + 6) - 48) * 10;
        int len1 = (buffer.getByte(index + 7) - 48) * 1;
        long result = len8 + len7 + len6 + len5 + len4 + len3 + len2 + len1;
        return result;
    }
}

