/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SortPlanManager;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.SortPlanItem;
import java.util.List;
import org.apache.log4j.Logger;

public class SortPlanTask
extends Thread {
    private static final Logger logger = Logger.getLogger(SortPlanTask.class);
    private static final int REQUEST_INTERVAL = 1000;

    public SortPlanTask() {
        this.setName("Sort-Plan-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Boolean machineStopped = SorterParams.getInstance().isMachineStopped();
                Boolean needSortPlan = SorterParams.getInstance().isNeedSortPlan();
                if (!needSortPlan.booleanValue() || machineStopped.booleanValue()) {
                    // empty if block
                }
                int sortPlanRequestTime = SorterParams.getInstance().getSortPlanRequestTime();
                long intervalTime = sortPlanRequestTime * 1000;
                Thread.sleep(intervalTime);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private void updateSortPlan() {
        try {
            List<SortPlanItem> sortPlanItems = SortPlanManager.getInstance().getSortPlanItems();
            sortPlanItems.clear();
            ICommand command = CommandCreator.getInstance().createCommand("WebSortPlanCmd", sortPlanItems);
            WebCommandExecutor.getInstance().executeCmd(command);
            if (sortPlanItems.size() > 0) {
                command = CommandCreator.getInstance().createCommand("TruncateTableCmd", "tt_sort_plan_info");
                SQLCommandExecutor.getInstance().executeCmd(command);
                command = CommandCreator.getInstance().createCommand("RecordSortPlanCmd", sortPlanItems);
                SQLCommandExecutor.getInstance().executeCmd(command);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Catch an exception in updateSortPlan [" + ex.getMessage() + "]");
        }
    }
}

