/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LogUtil;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PrinterInfoManager;
import com.simba.server.components.ScreenInfoManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.PrinterInfo;
import com.simba.server.components.data.SlotInfo;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ColorLightTask
extends Thread {
    private static final Logger logger = Logger.getLogger(ColorLightTask.class);
    private static final int REQUEST_INTERVAL = 10000;

    public ColorLightTask() {
        this.setName("Color-Light-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.reloadSlotStatus();
                Thread.sleep(10000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private void reloadSlotStatus() {
        try {
            LinkedList slots = new LinkedList();
            LinkedList<Integer> lockedSlots = new LinkedList<Integer>();
            ICommand command = CommandCreator.getInstance().createCommand("FetchSlotInfoCmd", slots);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (ret.booleanValue()) {
                for (SlotInfo slotTmp : slots) {
                    PrinterInfo printerInfo;
                    String slotId = slotTmp.getSlotId();
                    String printerMasterId = slotTmp.getMasterPrinterId();
                    String printerSlaveId = slotTmp.getSlavePrinterId();
                    int slotDistrict = slotTmp.getSlotDistrict();
                    SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
                    if (slotInfo == null) continue;
                    if (slotInfo.getLockStatus() > 0) {
                        lockedSlots.add(Integer.parseInt(slotId));
                    }
                    if ((printerInfo = PrinterInfoManager.getInstance().getPrinterInfo(printerMasterId)) != null) {
                        slotInfo.setMasterPrinterId(printerInfo.getPrinterId());
                        slotInfo.setMasterPrinterIp(printerInfo.getPrinterIp());
                    }
                    if ((printerInfo = PrinterInfoManager.getInstance().getPrinterInfo(printerSlaveId)) != null) {
                        slotInfo.setSlavePrinterId(printerInfo.getPrinterId());
                        slotInfo.setSlavePrinterIp(printerInfo.getPrinterIp());
                    }
                    slotInfo.setSlotDistrict(slotDistrict);
                }
            }
            if (lockedSlots.size() > 0) {
                ScreenInfoManager.getInstance().handleSlotLockStatus(lockedSlots);
            }
            Thread.sleep(10000L);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ColorLightTask.reloadSlotStatus] reload slots status error: " + ex, 2));
        }
    }

    private void LoopSendData() {
        ICommand command = CommandCreator.getInstance().createCommand("WebColorLightCmd", null);
        boolean ret = WebCommandExecutor.getInstance().executeCmd(command);
    }
}

