/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.netclient;

import com.simba.GlobalParam;
import com.simba.common.frameclient.IClient;
import com.simba.common.frameclient.IClientManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.XmlTools;
import com.simba.server.netclient.ClientNetTask;
import com.simba.server.netclient.DefaultBootstrapManager;
import com.simba.server.netclient.DefaultClientCreator;
import java.io.File;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class DefaultClientManager
implements IClientManager {
    protected static final Logger logger = Logger.getLogger(DefaultClientManager.class);
    private final ConcurrentHashMap<String, IClient> currentClients = new ConcurrentHashMap();
    private IClient defacultClient;
    private String defaultClientId;
    private final ClientNetTask netTask = new ClientNetTask();

    public static DefaultClientManager getInstance() {
        return DefaultClientManagerHolder.INSTANCE;
    }

    @Override
    public void addClient(IClient client) {
        this.currentClients.put(this.defaultClientId, client);
    }

    @Override
    public void checkClientStatus() {
        try {
            if (!this.defacultClient.isConnected().booleanValue() && this.defacultClient != null) {
                this.defacultClient.doReconnected();
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Reconnect Yunda Client: " + this.defacultClient.getId(), 3));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[DefaultClientManager.checkClientStatus] Catch Exception : " + ex.getMessage(), 2));
        }
    }

    @Override
    public IClient getClient(String clientId) {
        return this.currentClients.get(clientId);
    }

    @Override
    public int getClientCount() {
        return 0;
    }

    @Override
    public IClient[] getClientList() {
        return this.currentClients.values().toArray(new IClient[this.currentClients.size()]);
    }

    public int getClientStatus() {
        int status = 0;
        if (this.defacultClient != null && this.defacultClient.isConnected().booleanValue()) {
            status = 1;
        }
        return status;
    }

    @Override
    public void init(String configFile) {
        try {
            Document rootDoc = XmlTools.getXmlDocFromFile(new File("etc" + GlobalParam.PATH_SEP + configFile));
            Element root = rootDoc.getRootElement();
            this.initClients(root);
            this.startNetTask();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Clients init error : " + ex.getMessage(), 2));
        }
    }

    @Override
    public IClient removeClient(String clientId) {
        return null;
    }

    private void initClients(Element root) {
        List<Element> clients = root.getChildren();
        Element clientElement = clients.get(0);
        if (clientElement != null) {
            String name = clientElement.getAttributeValue("name");
            String serverHost = clientElement.getAttributeValue("ip");
            String port = clientElement.getAttributeValue("port");
            int serverPort = Integer.parseInt(port);
            this.defaultClientId = name + "-" + serverHost + ":" + port;
            this.defacultClient = DefaultClientCreator.getInstance().createClient(name);
            this.addClient(this.defacultClient);
            this.defacultClient.start(this.defaultClientId, serverHost, serverPort, name, DefaultBootstrapManager.getInstance());
        }
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[DefaultClientManager.initClients] DefaultClient ID : [" + this.defaultClientId + "]", 3));
    }

    private void startNetTask() {
        this.netTask.start();
    }

    private static class DefaultClientManagerHolder {
        private static final DefaultClientManager INSTANCE = new DefaultClientManager();

        private DefaultClientManagerHolder() {
        }
    }
}

