/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.BarcodeManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.data.SortInfo;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SortInfoDecoder
implements Decoder {
    public static final int CAR_HAS_NO_PACKET = 0;
    public static final int CAR_HAS_PACKET = 1;
    public static final String NAME = "SortInfo";
    protected static final Logger logger = Logger.getLogger(SortInfoDecoder.class);
    private static final int BARCODE_NUMBER_POSITION = 8;
    private static final int CAR_ID_POSITION = 3;
    private static final int CAR_STATUS_POSITION = 5;
    private static final String INVALID_READ_BARCODE = "Invalid-Code";
    private static final int OBR_NUM_POSITION = 7;
    private static final int TRIGGER_STATUS_POSITION = 6;
    private static final int TRIGGER_TO_GET_SLOT = 1;

    public static SortInfoDecoder getInstance() {
        return DecoderHolder.INSTANCE;
    }

    private SortInfoDecoder() {
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        try {
            if (!(message instanceof byte[])) {
                return;
            }
            byte[] content = (byte[])message;
            int carIdInt = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            String carIdStr = String.valueOf(carIdInt);
            byte carStatus = content[5];
            if (carStatus != 1) {
                return;
            }
            byte trriggerStatus = content[6];
            if (trriggerStatus != 1) {
                return;
            }
            SortInfo sortInfo = SortInfoManager.getInstance().createSortInfo();
            sortInfo.setCarId(carIdStr);
            byte obr = content[7];
            if (obr != 1 && obr != 2 && obr != 3) {
                obr = 1;
            }
            sortInfo.setObr(obr);
            int barcodeNumber = content[8];
            int barcodePosition = 9;
            String invalidBarcode = INVALID_READ_BARCODE;
            boolean isErrorMsg = false;
            String validBarCode = "";
            int priorLevel = 0;
            for (int i = 0; i < barcodeNumber; ++i) {
                byte barcodeLen = content[barcodePosition];
                if (barcodeLen < 0 || barcodeLen > 128) {
                    isErrorMsg = true;
                    continue;
                }
                String barcode = new String(content, ++barcodePosition, (int)barcodeLen, "UTF-8");
                if (BarcodeManager.getInstance().checkBarcodeValid(barcode).booleanValue()) {
                    int curPriority = 0;
                    curPriority = barcode.toLowerCase().startsWith("yt") ? 100 : barcode.length();
                    if (curPriority > priorLevel) {
                        sortInfo.setBarcode(barcode);
                        priorLevel = curPriority;
                    }
                    sortInfo.getBarcodeList().add(barcode);
                    validBarCode = barcode;
                } else {
                    invalidBarcode = barcode;
                }
                barcodePosition += barcodeLen;
            }
            String plcId = "NoDefine";
            String uuid = "NoDefine";
            int turnNumber = 0;
            int platId = 0;
            if (!isErrorMsg) {
                int plcIdLenPosition = barcodePosition;
                int plcIdPosition = plcIdLenPosition + 1;
                byte plcIdLen = content[plcIdLenPosition];
                byte[] plcIdBuffer = new byte[10];
                System.arraycopy(content, plcIdPosition, plcIdBuffer, 0, 10);
                try {
                    plcId = new String(plcIdBuffer, "UTF-8");
                    sortInfo.setPlcId(plcId);
                }
                catch (Exception e) {
                    plcId = "Parse-PLCID-Error";
                }
                byte[] guidBuffer = new byte[32];
                System.arraycopy(content, plcIdPosition += 10, guidBuffer, 0, 32);
                try {
                    uuid = new String(guidBuffer, "UTF-8");
                    sortInfo.setUuid(uuid);
                }
                catch (Exception e) {
                    uuid = "Parse-uuid-Error";
                }
                int turnNumberPosition = plcIdPosition + 32;
                turnNumber = content[turnNumberPosition];
                sortInfo.setTurnNumber(String.valueOf(turnNumber));
                int platIdPosition = turnNumberPosition + 1;
                platId = content[platIdPosition];
                sortInfo.setPlatId(String.valueOf(platId));
                int LengthPos = platIdPosition + 1;
                byte[] lengthBuffer = new byte[4];
                System.arraycopy(content, LengthPos, lengthBuffer, 0, 4);
                String length = new String(lengthBuffer, "UTF-8");
                int iLenght = Integer.parseInt(length);
                sortInfo.setLength(iLenght);
                int widthPos = LengthPos + 4;
                byte[] widthBuffer = new byte[4];
                System.arraycopy(content, widthPos, widthBuffer, 0, 4);
                String width = new String(widthBuffer, "UTF-8");
                int iwidth = Integer.parseInt(width);
                sortInfo.setWidth(iwidth);
                int heightPos = widthPos + 4;
                byte[] heightBuffer = new byte[4];
                System.arraycopy(content, heightPos, heightBuffer, 0, 4);
                String height = new String(heightBuffer, "UTF-8");
                int iheight = Integer.parseInt(height);
                sortInfo.setHeight(iheight);
                int volumePos = heightPos + 4;
                byte[] volumeBuffer = new byte[8];
                System.arraycopy(content, volumePos, volumeBuffer, 0, 8);
                String volume = new String(volumeBuffer, "UTF-8");
                int ivolume = Integer.parseInt(volume);
                sortInfo.setVolume(ivolume);
            } else {
                LogUtil.LogError(logger, "[SortInfoDecoder.doDecode] parse barcode info error first barcode: " + validBarCode + "");
            }
            sortInfo.setPlcId(plcId);
            sortInfo.setTurnNumber(String.valueOf(turnNumber));
            sortInfo.setPlatId(String.valueOf(platId));
            BarcodeManager.getInstance().createSortInfoBarcodeList(sortInfo);
            if (sortInfo.getBarcodeList().size() == 0) {
                sortInfo.setBarcode("NoRead");
                sortInfo.getBarcodeList().add("NoRead");
                sortInfo.setErrorCodeSVR(3);
            }
            SortControllerManager.getInstance().onSortInfoMessage(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortInfoDecoder.doDecode] Do decode sort info error : " + ex.toString() + "]");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void handleMultiBarcodes(SortInfo sortInfo) {
        String barcodes = "";
        List<String> barcodeList = sortInfo.getBarcodeList();
        for (int i = 0; i < barcodeList.size(); ++i) {
            barcodes = i < barcodeList.size() - 1 ? barcodes + barcodeList.get(i) + "," : barcodes + barcodeList.get(i);
        }
        sortInfo.setBarcode(barcodes);
    }

    public void sendSortInfoToClient(SortInfo sortInfo) {
    }

    private static class DecoderHolder {
        private static final SortInfoDecoder INSTANCE = new SortInfoDecoder();

        private DecoderHolder() {
        }
    }
}

