/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotPackDecoder
implements Decoder {
    public static final String NAME = "SlotPack";
    protected static final Logger logger = Logger.getLogger(SlotPackDecoder.class);
    private static final int SLOT_ID_POSITION = 3;

    public static SlotPackDecoder getDecoderInstance() {
        return SlotPackDecoderHolder.INSTANCE;
    }

    private SlotPackDecoder() {
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        try {
            byte[] content = (byte[])message;
            int slotIdValue = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            String slotKey = String.valueOf(slotIdValue);
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotKey);
            if (slotInfo == null) {
                return;
            }
            SortControllerManager.getInstance().onSlotPackMessage(slotInfo);
            this.sendSlotPackEchoToPLC(content);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Slot Pack Error -- Exception : " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendSlotPackEchoToPLC(byte[] content) {
        SortProtocolCreator.getInstance().sendContentEchoToPLC(content);
    }

    private static class SlotPackDecoderHolder {
        private static final SlotPackDecoder INSTANCE = new SlotPackDecoder();

        private SlotPackDecoderHolder() {
        }
    }
}

