/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class PlatStatusDecoder
implements Decoder {
    public static final String NAME = "PlatStatus";
    protected static final Logger logger = Logger.getLogger(PlatStatusDecoder.class);
    private static final int PLAT_ID_POSITION = 3;
    private static final int PLAT_MODE_POSITION = 4;
    private static final int PLAT_STATUS_POSITION = 5;

    public static PlatStatusDecoder getInstance() {
        return DecoderHolder.INSTANCE;
    }

    private PlatStatusDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            byte platIdBinary = content[3];
            String platId = String.valueOf(platIdBinary);
            byte platMode = content[4];
            byte platStatus = content[5];
            PlatInstance plat = PlatManager.getInstance().getPlatById(platId);
            if (plat != null) {
                plat.setPlatMode(platMode);
                plat.setPlatStatus(platStatus);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Plat Scanned Decode Catch Exception : " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class DecoderHolder {
        private static final PlatStatusDecoder INSTANCE = new PlatStatusDecoder();

        private DecoderHolder() {
        }
    }
}

