/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.PacketOnInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class PacketOnDecoder
implements Decoder {
    public static final String NAME = "PacketOn";
    protected static final Logger logger = Logger.getLogger(PacketOnDecoder.class);
    private static final int BARCODE_LEN_POSITION = 7;
    private static final int BARCODE_POSITION = 8;
    private static final int CAR_ID_POSITION = 3;
    private static final int PLAT_ID_POSITION = 5;
    private static final int PLAT_MODE_POSITION = 6;

    public static PacketOnDecoder getDecoderInstance() {
        return PacketOnDecoderHolder.INSTANCE;
    }

    private PacketOnDecoder() {
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        try {
            byte[] content = (byte[])message;
            int carIdValue = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            String carId = String.valueOf(carIdValue);
            byte platIdBinary = content[5];
            String platId = String.valueOf(platIdBinary);
            byte modeBinary = content[6];
            String mode = String.valueOf(modeBinary);
            byte barcodeLen = content[7];
            String barcode = "none-barcode";
            if (barcodeLen != 0) {
                barcode = new String(content, 8, (int)barcodeLen, "UTF-8");
            }
            int plcIdLenPosition = 8 + barcodeLen;
            int plcIdPosition = 8 + barcodeLen + 1;
            byte plcIdLen = content[plcIdLenPosition];
            String plcId = new String(content, plcIdPosition, (int)plcIdLen, "UTF-8");
            PacketOnInfo packetOnInfo = new PacketOnInfo();
            packetOnInfo.setCarId(carId);
            packetOnInfo.setPlatId(platId);
            packetOnInfo.setPlatMode(mode);
            packetOnInfo.setPlatModeValue(modeBinary);
            packetOnInfo.setWorkerNo("none");
            packetOnInfo.setPlcId(plcId);
            packetOnInfo.setBarcode(barcode);
            packetOnInfo.setContent(content);
            SortControllerManager.getInstance().onPacketOnMessage(packetOnInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "PacketOn Decoder Error : exception info : " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class PacketOnDecoderHolder {
        private static final PacketOnDecoder INSTANCE = new PacketOnDecoder();

        private PacketOnDecoderHolder() {
        }
    }
}

