/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder;

import com.simba.common.RequestHandler;
import com.simba.common.decoder.Decoder;
import com.simba.common.decoder.DecoderContainer;
import com.simba.common.decoder.DefaultDecoderContainer;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.common.thread.CommonExecutorFactory;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.server.ServerParam;
import com.simba.server.components.SortCommonDefines;
import com.simba.server.components.SorterParams;
import com.simba.server.framedecoder.decoders.EchoTimeDecoder;
import com.simba.server.framedecoder.decoders.EmergencyStopDecoder;
import com.simba.server.framedecoder.decoders.ErrorPacketOffDecoder;
import com.simba.server.framedecoder.decoders.MachineErrorDecoder;
import com.simba.server.framedecoder.decoders.MachineStatusDecoder;
import com.simba.server.framedecoder.decoders.PacketOffDecoder;
import com.simba.server.framedecoder.decoders.PacketOnDecoder;
import com.simba.server.framedecoder.decoders.PlatScannedDecoder;
import com.simba.server.framedecoder.decoders.PlatStatusDecoder;
import com.simba.server.framedecoder.decoders.PlcSyncDecoder;
import com.simba.server.framedecoder.decoders.SlotPackDecoder;
import com.simba.server.framedecoder.decoders.SlotUnlockDecoder;
import com.simba.server.framedecoder.decoders.SortCmdTestDecoder;
import com.simba.server.framedecoder.decoders.SortInfoDecoder;
import com.simba.server.framedecoder.decoders.TrashSlotsDecoder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class FrameDecoderManager
implements RequestHandler {
    public static final byte CONNECT_MESSGAE_END = -18;
    public static final byte CONNECT_MESSGAE_HEAD = -1;
    protected static final Logger logger = Logger.getLogger(FrameDecoderManager.class);
    private static int ASYNC_EXECUTOR_POOL_SIZE = 8;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Frame-Decode-Task";
    private Executor asyncDecodeExecutor;
    private BlockingQueue<Runnable> asyncDecodeOperationQueue;
    private final DecoderContainer decoderContainer = new DefaultDecoderContainer();

    public static FrameDecoderManager getInstance() {
        return FrameDecoderManagerHolder.INSTANCE;
    }

    private FrameDecoderManager() {
    }

    @Override
    public void handleRequest(final Channel channel, final Object message) {
        Runnable executeRunnable = new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (!(message instanceof byte[])) {
                            LogUtil.LogDebug(logger, "FrameDecoder only can decode byte frame,but message is not instance of byte[].");
                            FrameChannelManager.getInstance().commitResponse(channel, SortCommonDefines.ERROR_MESSAGE, true);
                            return;
                        }
                        byte[] content = (byte[])message;
                        if (content[0] != 1 || content[1] != 2) {
                            byte[] errorBuffer = new byte[]{2, 1, -18, 1, 13, 10};
                            FrameChannelManager.getInstance().commitResponse(channel, errorBuffer, true);
                            return;
                        }
                        byte command = content[2];
                        Decoder frameDecoder = FrameDecoderManager.this.getDecoderByCommandNum(command);
                        if (frameDecoder != null) {
                            frameDecoder.doDecode(channel, message);
                        }
                    }
                    catch (Exception ex) {
                        LogUtil.LogError(logger, "FrameDecoderManager catch exception : " + ex.getMessage());
                        if (!(ex instanceof InterruptedException)) break block5;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        if (SorterParams.getInstance().isNewThreadEachRequest()) {
            this.executeInNewThread(executeRunnable);
        } else {
            this.executeInThreadPool(executeRunnable);
        }
    }

    public void init() {
        this.initAsyncTaskExcutor();
        this.initDecoderContainer();
    }

    public void postInitProcess() {
        String requestMode = "Request In New Thread";
        if (!SorterParams.getInstance().isNewThreadEachRequest()) {
            requestMode = "Request In Thread Pool";
        }
        LogUtil.LogDebug(logger, "FrameDecoderManager initialize successfully, Pool size:[" + ASYNC_EXECUTOR_POOL_SIZE + "] reqeust mode:[" + requestMode + "]");
    }

    private void executeInNewThread(Runnable executeRunnable) {
        new Thread(executeRunnable).start();
    }

    private void executeInThreadPool(Runnable executeRunnable) {
        this.runAsyncDecodeTask(executeRunnable);
    }

    private Decoder getDecoderByCommandNum(byte command) {
        Decoder frameDecoder = null;
        switch (command) {
            case 1: {
                frameDecoder = this.decoderContainer.getDecoder("MachineStatus");
                break;
            }
            case 2: {
                frameDecoder = this.decoderContainer.getDecoder("MachineError");
                break;
            }
            case 3: {
                frameDecoder = this.decoderContainer.getDecoder("PacketOn");
                break;
            }
            case 5: {
                frameDecoder = this.decoderContainer.getDecoder("PlatScanned");
                break;
            }
            case 6: {
                frameDecoder = this.decoderContainer.getDecoder("SortInfo");
                break;
            }
            case 8: {
                frameDecoder = this.decoderContainer.getDecoder("PacketOff");
                break;
            }
            case 9: {
                frameDecoder = this.decoderContainer.getDecoder("SlotPack");
                break;
            }
            case 10: {
                frameDecoder = this.decoderContainer.getDecoder("SlotUnlock");
                break;
            }
            case 11: {
                frameDecoder = this.decoderContainer.getDecoder("ErrorPacketOff");
                break;
            }
            case 17: {
                frameDecoder = this.decoderContainer.getDecoder("EchoTime");
                break;
            }
            case 21: {
                frameDecoder = this.decoderContainer.getDecoder("PlatStatus");
                break;
            }
            case -16: {
                frameDecoder = this.decoderContainer.getDecoder("TrashSlots");
                break;
            }
            case -1: {
                frameDecoder = this.decoderContainer.getDecoder("SortCmdTest");
                break;
            }
            case 51: {
                frameDecoder = this.decoderContainer.getDecoder("EmergencyStop");
            }
        }
        return frameDecoder;
    }

    private void initAsyncTaskExcutor() {
        if (ServerParam.DECODER_THREAD_POOL_SIZE > 0) {
            ASYNC_EXECUTOR_POOL_SIZE = ServerParam.DECODER_THREAD_POOL_SIZE;
        }
        this.asyncDecodeOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncDecodeExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncDecodeOperationQueue);
    }

    private void initDecoderContainer() {
        this.decoderContainer.addDecoder("MachineStatus", MachineStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("MachineError", MachineErrorDecoder.getInstance());
        this.decoderContainer.addDecoder("PlcSync", PlcSyncDecoder.getInstance());
        this.decoderContainer.addDecoder("PacketOn", PacketOnDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("PlatScanned", PlatScannedDecoder.getInstance());
        this.decoderContainer.addDecoder("PlatStatus", PlatStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("PacketOff", PacketOffDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("SortInfo", SortInfoDecoder.getInstance());
        this.decoderContainer.addDecoder("SlotPack", SlotPackDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("SlotUnlock", SlotUnlockDecoder.getInstance());
        this.decoderContainer.addDecoder("ErrorPacketOff", ErrorPacketOffDecoder.getInstance());
        this.decoderContainer.addDecoder("TrashSlots", TrashSlotsDecoder.getInstance());
        this.decoderContainer.addDecoder("EchoTime", EchoTimeDecoder.getInstance());
        this.decoderContainer.addDecoder("SortCmdTest", new SortCmdTestDecoder());
        this.decoderContainer.addDecoder("EmergencyStop", EmergencyStopDecoder.getDecoderInstance());
    }

    private void runAsyncDecodeTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncDecodeExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "Run async task to decode failed : " + e.getMessage());
        }
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onChannelDisconnected(Channel channel) {
    }

    private static class FrameDecoderManagerHolder {
        private static final FrameDecoderManager INSTANCE = new FrameDecoderManager();

        private FrameDecoderManagerHolder() {
        }
    }
}

