/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortPlanItem;
import com.simba.server.controllers.IPlatScannedController;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class DepponPlatScannedController
implements IPlatScannedController {
    private static final Logger logger = Logger.getLogger(DepponPlatScannedController.class);

    @Override
    public void onPlatScannedMessage(SortInfo sortInfo) {
        try {
            String scannedPlatType = sortInfo.getScannedPlatType();
            if (scannedPlatType.equals("MANUAL")) {
                this.requestSortPlan(sortInfo);
            } else {
                this.requestSortInfo(sortInfo);
            }
            this.restoreScannedInfo(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Request Deppon Sort Info Error -- Exception : " + ex);
        }
    }

    private void printWebSortInfoError(SortInfo sortInfo) {
        String barcode = sortInfo.getBarcode();
        LogUtil.LogError(logger, "[DepponPlatScannedController.printWebSortInfoError] billCode : [" + barcode + "] errorCode : [" + sortInfo.getErrorCodeSVR() + "]");
    }

    private void requestSortInfo(SortInfo sortInfo) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("WebSortInfoCmd", sortInfo);
            Boolean res = WebCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                this.printWebSortInfoError(sortInfo);
            }
            SortInfoManager.getInstance().handleSortInfoResult(sortInfo);
            this.sendScannedResultToPLC(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Request Deppon Sort Info Error -- Exception : " + ex);
        }
    }

    private void requestSortPlan(SortInfo sortInfo) {
        try {
            LinkedList<SortPlanItem> sortPlanItems = new LinkedList<SortPlanItem>();
            SortPlanItem item = new SortPlanItem();
            item.setSiteCode(sortInfo.getSiteCode());
            sortPlanItems.add(item);
            ICommand command = CommandCreator.getInstance().createCommand("FetchSortPlanCmd", sortPlanItems);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (ret.booleanValue() && sortPlanItems.size() > 0) {
                for (SortPlanItem sortPlanItem : sortPlanItems) {
                    String slotId = sortPlanItem.getChuteCode1();
                    sortInfo.getSlotsList().add(Integer.parseInt(slotId));
                }
            } else {
                sortInfo.setErrorCodeSVR(2);
            }
            SortInfoManager.getInstance().handleSortInfoResult(sortInfo);
            this.sendScannedResultToPLC(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[DepponPlatScannedController.requestSortPlan] : Error -- Exception : " + ex);
        }
    }

    private void restoreScannedInfo(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("RecordPlatScannedCmd", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void sendScannedResultToPLC(SortInfo sortInfo) {
        Channel[] clients;
        byte[] replyBuffer = SortProtocolCreator.getInstance().createSortCmdWithPlat(sortInfo);
        for (Channel client : clients = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(client, replyBuffer, false);
        }
    }
}

