/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.common.utils.StringUtil;
import com.simba.server.components.MachineParams;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortCommonDefines;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortResult;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class SortProtocolCreator {
    private static final Logger logger = Logger.getLogger(SortProtocolCreator.class);
    private static final int MACHINE_PARAMS_SEND_BUFFER_SIZE = 33;
    private static final byte PLAT_MODE_SCANNED = 3;
    private static final int RESET_PLAT_RRESULT_BUFFER_SIZE = 15;
    private static final int SLOT_SOFT_LOCK_CONSTANT_SIZE = 17;
    private static final int SLOT_SOFT_LOCK_STATUS_CONSTANT_SIZE = 14;
    private static final int SORT_CMD_CONSTANT_BUFFER_SIZE = 28;
    private static final int TSH_SLOTS_SEND_BUFFER_SIZE = 20;
    private final Map<Integer, String> errorCodesMap = new HashMap<Integer, String>();

    public static SortProtocolCreator getInstance() {
        return SortProtocolManagerHolder.INSTANCE;
    }

    private SortProtocolCreator() {
    }

    public String createGetLineCode() {
        JSONObject requestObject = new JSONObject();
        requestObject.put("deviceType", SorterParams.getInstance().getDevType());
        requestObject.put("companyName", SorterParams.getInstance().getCompany());
        requestObject.put("version", SorterParams.getInstance().getVersion());
        requestObject.put("orgCode", SorterParams.getInstance().getOrgCode());
        return requestObject.toString();
    }

    public String createGetBasicConfig() {
        JSONObject requestObject = new JSONObject();
        requestObject.put("lineCode", SorterParams.getInstance().getLineCode());
        requestObject.put("switchTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        requestObject.put("status", "start");
        return requestObject.toString();
    }

    public String createGetWblCodeRule(String lineCode) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("lineCode", lineCode);
        return requestObject.toString();
    }

    public String createGetSortCode(SortInfo sortInfo) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("wblCode", sortInfo.getBarcode());
        requestObject.put("lineCode", SorterParams.getInstance().getLineCode());
        requestObject.put("scanTime", sortInfo.getScanTime());
        if (StringUtil.isNotNull(sortInfo.getCarId()).booleanValue()) {
            requestObject.put("trayCode", sortInfo.getCarId());
        }
        requestObject.put("camaerCode", "0" + sortInfo.getObr());
        if (StringUtil.isNull(sortInfo.getPlatId()).booleanValue()) {
            requestObject.put("supplyCode", "00");
        } else {
            requestObject.put("supplyCode", sortInfo.getPlatId());
        }
        requestObject.put("layer", "1");
        if (!StringUtil.isNull(String.valueOf(sortInfo.getErrorCodeSVR())).booleanValue()) {
            requestObject.put("errCode", String.valueOf(sortInfo.getErrorCodeSVR()));
        }
        return requestObject.toString();
    }

    public String createUploadSortResult(SortResult sortResult) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("id", sortResult.getSortInfos().get(0).getDepId());
        requestObject.put("wblCode", sortResult.getSortInfos().get(0).getBarcode());
        requestObject.put("lineCode", SorterParams.getInstance().getLineCodeList().get(0));
        requestObject.put("sortTime", sortResult.getSortInfos().get(0).getTimePacketOff());
        requestObject.put("turnNumber", sortResult.getSortInfos().get(0).getTurnNumber());
        requestObject.put("trayCode", sortResult.getSortInfos().get(0).getCarId());
        requestObject.put("endcamaerCode", "0" + sortResult.getSortInfos().get(0).getObr());
        if (StringUtil.isNull(sortResult.getSortInfos().get(0).getPlatId()).booleanValue()) {
            requestObject.put("supplyCode", "00");
        } else if (sortResult.getSortInfos().get(0).getPlatId().length() == 1) {
            requestObject.put("supplyCode", "0" + sortResult.getSortInfos().get(0).getPlatId());
        } else {
            requestObject.put("supplyCode", sortResult.getSortInfos().get(0).getPlatId());
        }
        requestObject.put("layer", "1");
        if (!StringUtil.isNull(sortResult.getSortInfos().get(0).getComplementCode()).booleanValue()) {
            requestObject.put("complementCode", sortResult.getSortInfos().get(0).getComplementCode());
        } else {
            requestObject.put("complementCode", "");
        }
        String errorCode = String.valueOf(sortResult.getSortInfos().get(0).getErrorCodeSVR());
        int errorOriSvr = sortResult.getSortInfos().get(0).getOriginalErrorCode();
        if (errorOriSvr > 0) {
            errorCode = String.valueOf(errorOriSvr);
        }
        if (errorCode != null && errorCode.length() > 1) {
            requestObject.put("errCode", errorCode);
        }
        int sortCode = sortResult.getSortInfos().get(0).getDroppedSlotId();
        String strSlot = SlotManager.getInstance().getSortCode(sortCode);
        requestObject.put("sortCode", strSlot);
        requestObject.put("sortSource", String.valueOf(sortResult.getSortInfos().get(0).getSortSource()));
        if (StringUtil.isNotNull(sortResult.getSortInfos().get(0).getPackageNo()).booleanValue()) {
            requestObject.put("packageNo", sortResult.getSortInfos().get(0).getPackageNo());
        }
        if (!StringUtil.isNull(sortResult.getSortInfos().get(0).getUserCode()).booleanValue()) {
            requestObject.put("userCode", sortResult.getSortInfos().get(0).getUserCode());
        }
        return requestObject.toString();
    }

    public String createGetPackageNo(SlotInfo slotInfo) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("lineCode", slotInfo.getLineCode());
        requestObject.put("sortCode", slotInfo.getSortCode());
        requestObject.put("operateTime", slotInfo.getOperateTime());
        return requestObject.toString();
    }

    public String createAddScanContent(SortInfo sortInfo) {
        JSONObject requestObj = new JSONObject();
        requestObj.put("packageCode", sortInfo.getBarcode());
        requestObj.put("machineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("carNo", sortInfo.getCarId());
        requestObj.put("tranceId", "000000");
        requestObj.put("supplyNo", sortInfo.getPlatId());
        String supplyType = this.addScanSupplyType(sortInfo);
        requestObj.put("supplyType", supplyType);
        String scanNo = this.addScanObrNo(sortInfo);
        requestObj.put("scanNo", scanNo);
        String chuteCode = String.valueOf(sortInfo.getDroppedSlotId());
        requestObj.put("chuteCode", chuteCode);
        requestObj.put("weight", 0);
        requestObj.put("length", 0);
        requestObj.put("width", 0);
        requestObj.put("height", 0);
        String errorCodeDesc = this.addScanExpType(sortInfo.getErrorCodePLC());
        requestObj.put("expType", errorCodeDesc);
        requestObj.put("operateTime", sortInfo.getTimePacketOff());
        return requestObj.toString();
    }

    public String createBoxInfoContent(SlotInfo slotInfo) {
        JSONObject requestObj = new JSONObject();
        String chuteCode = slotInfo.getSlotId();
        requestObj.put("ChuteCode", chuteCode);
        requestObj.put("MachineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("RequestTime", this.createCurrentTimeStamp());
        return requestObj.toString();
    }

    public String createPrintChuteContent(SlotInfo slotInfo) {
        JSONObject requestObj = new JSONObject();
        String chuteCode = slotInfo.getSlotId();
        requestObj.put("Guid", this.getUUID());
        requestObj.put("BoxCode", slotInfo.getBoxInfo().getBoxCode());
        requestObj.put("Barcodes", slotInfo.getBoxInfo().getBarcodeList());
        requestObj.put("ChuteCode", chuteCode);
        requestObj.put("MachineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("RequestTime", this.createCurrentTimeStamp());
        return requestObj.toString();
    }

    public String createSlotStatusContent(SlotInfo slotInfo) {
        JSONObject requestObj = new JSONObject();
        String chuteCode = slotInfo.getSlotId();
        requestObj.put("Guid", this.getUUID());
        requestObj.put("MachineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("ChuteCode", chuteCode);
        requestObj.put("Status", slotInfo.getLockStatus());
        requestObj.put("RequestTime", this.createCurrentTimeStamp());
        return requestObj.toString();
    }

    public String createSlotLockedStatusContent(List<Integer> lockedSlots) {
        JSONObject requestObj = new JSONObject();
        requestObj.put("Guid", this.getUUID());
        requestObj.put("MachineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("ChuteCode", lockedSlots);
        requestObj.put("RequestTime", this.createCurrentTimeStamp());
        return requestObj.toString();
    }

    public String getUUID() {
        UUID uuid = UUID.randomUUID();
        String strUUID = uuid.toString();
        strUUID = strUUID.replace("-", "");
        return strUUID;
    }

    public Timestamp createCurrentTimeStamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public byte[] createMachineParams() {
        byte[] replyBuffer = null;
        try {
            int bufferSize = 33;
            replyBuffer = new byte[bufferSize];
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{38};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            boolean planmode = false;
            byte[] planModeBuf = new byte[]{(byte)(planmode ? 1 : 0)};
            System.arraycopy(planModeBuf, 0, replyBuffer, position += command.length, planModeBuf.length);
            int clearMode = MachineParams.getInstance().getClearMode();
            byte[] clearModeBuf = new byte[]{(byte)clearMode};
            System.arraycopy(clearModeBuf, 0, replyBuffer, position += planModeBuf.length, clearModeBuf.length);
            boolean finish = true;
            byte[] finishBuf = new byte[]{(byte)(finish ? 1 : 0)};
            System.arraycopy(finishBuf, 0, replyBuffer, position += clearModeBuf.length, finishBuf.length);
            boolean dropMode = true;
            byte[] dropModeBuf = new byte[]{(byte)(dropMode ? 1 : 0)};
            System.arraycopy(dropModeBuf, 0, replyBuffer, position += finishBuf.length, dropModeBuf.length);
            int maxLoopCircles = MachineParams.getInstance().getMaxLoopCircles();
            byte[] maxLoopCirclesBuf = new byte[]{(byte)maxLoopCircles};
            System.arraycopy(maxLoopCirclesBuf, 0, replyBuffer, position += dropModeBuf.length, maxLoopCirclesBuf.length);
            int maxScanTimes = MachineParams.getInstance().getMaxLoopCircles();
            byte[] maxScanTimesBuf = new byte[]{(byte)maxScanTimes};
            System.arraycopy(maxScanTimesBuf, 0, replyBuffer, position += maxLoopCirclesBuf.length, maxScanTimesBuf.length);
            int sorterMaintainSpeed = MachineParams.getInstance().getSorterSpeed();
            byte[] sorterMaintainSpeedBuf = new byte[2];
            FrameUtils.getInstance().setShortBigEndian(0, sorterMaintainSpeed, sorterMaintainSpeedBuf);
            System.arraycopy(sorterMaintainSpeedBuf, 0, replyBuffer, position += maxScanTimesBuf.length, sorterMaintainSpeedBuf.length);
            int startWarnTime = MachineParams.getInstance().getStartWarnTime();
            byte[] startWarnTimeBuf = new byte[]{(byte)startWarnTime};
            System.arraycopy(startWarnTimeBuf, 0, replyBuffer, position += sorterMaintainSpeedBuf.length, startWarnTimeBuf.length);
            int clearStopTime = MachineParams.getInstance().getClearStopTime();
            byte[] clearStopTimeBuf = new byte[]{(byte)clearStopTime};
            System.arraycopy(clearStopTimeBuf, 0, replyBuffer, position += startWarnTimeBuf.length, clearStopTimeBuf.length);
            int clearStopCircles = MachineParams.getInstance().getClearStopCircles();
            byte[] clearStopCirclesBuf = new byte[]{(byte)clearStopCircles};
            System.arraycopy(clearStopCirclesBuf, 0, replyBuffer, position += clearStopTimeBuf.length, clearStopCirclesBuf.length);
            int noreadWarn = MachineParams.getInstance().getNoreadWarn();
            byte[] noreadWarnBuf = new byte[]{(byte)noreadWarn};
            System.arraycopy(noreadWarnBuf, 0, replyBuffer, position += clearStopCirclesBuf.length, noreadWarnBuf.length);
            int saveElecTime = MachineParams.getInstance().getSaveElecTime();
            byte[] saveElecTimeBuf = new byte[]{(byte)saveElecTime};
            System.arraycopy(saveElecTimeBuf, 0, replyBuffer, position += noreadWarnBuf.length, saveElecTimeBuf.length);
            int pidaiInterval = MachineParams.getInstance().getPidaiInterval();
            byte[] pidaiIntervalBuf = new byte[]{(byte)pidaiInterval};
            System.arraycopy(pidaiIntervalBuf, 0, replyBuffer, position += saveElecTimeBuf.length, pidaiIntervalBuf.length);
            int pidaiCheckTime = MachineParams.getInstance().getPidaiCheckTime();
            byte[] pidaiCheckTimeBuf = new byte[]{(byte)pidaiCheckTime};
            System.arraycopy(pidaiCheckTimeBuf, 0, replyBuffer, position += pidaiIntervalBuf.length, pidaiCheckTimeBuf.length);
            byte[] timeBuffer = FrameUtils.getInstance().createSystemTimeToBuffer();
            System.arraycopy(timeBuffer, 0, replyBuffer, position += pidaiCheckTimeBuf.length, timeBuffer.length);
            position += timeBuffer.length;
            byte[] serialByte = new byte[]{1};
            System.arraycopy(serialByte, 0, replyBuffer, replyBuffer.length - 3, serialByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, replyBuffer.length - 2, replayEnder.length);
            int n = (position += serialByte.length) + replayEnder.length;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortCommandManager.sendMachineParams] Create Machine Params Buffer Error -- Exception : " + ex);
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public byte[] createResetPlatBuffer(int platId) {
        byte[] replyBuffer = new byte[15];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{14};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] platformId = new byte[]{(byte)platId};
        System.arraycopy(platformId, 0, replyBuffer, position += command.length, platformId.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += platformId.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public String createSlotPackContent(BoxInfo boxInfo) {
        JSONObject requestObj = new JSONObject();
        requestObj.put("boxCode", boxInfo.getBoxCode());
        requestObj.put("machineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("mailCount", boxInfo.getMailCount());
        String chuteCode = boxInfo.getChuteCode();
        requestObj.put("chuteCode", Integer.parseInt(chuteCode));
        requestObj.put("boxType", boxInfo.getBoxType());
        requestObj.put("receiveSiteCode", boxInfo.getReceiveSiteCode());
        requestObj.put("createTime", boxInfo.getCreateTime());
        return requestObj.toString();
    }

    public byte[] createSlotSoftLock(int slotId) {
        int bufferLen = 17;
        byte[] replyBuffer = new byte[bufferLen];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{18};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] slotIdBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, slotId, slotIdBuf);
        System.arraycopy(slotIdBuf, 0, replyBuffer, position += command.length, slotIdBuf.length);
        byte[] slotLockStatus = new byte[]{1};
        System.arraycopy(slotLockStatus, 0, replyBuffer, position += slotIdBuf.length, slotLockStatus.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += slotLockStatus.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public byte[] createSlotSoftLockStatus(byte[] slotLockStatus) {
        int bufferLen = 14 + slotLockStatus.length;
        byte[] replyBuffer = new byte[bufferLen];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{20};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        System.arraycopy(slotLockStatus, 0, replyBuffer, position += command.length, slotLockStatus.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += slotLockStatus.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public byte[] createSlotSoftUnLock(int slotId) {
        int bufferLen = 17;
        byte[] replyBuffer = new byte[bufferLen];
        int position = 0;
        byte[] header = SortCommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{19};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] slotIdBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, slotId, slotIdBuf);
        System.arraycopy(slotIdBuf, 0, replyBuffer, position += command.length, slotIdBuf.length);
        boolean slotUnlock = false;
        byte[] slotLockStatus = new byte[]{(byte)(slotUnlock ? 1 : 0)};
        System.arraycopy(slotLockStatus, 0, replyBuffer, position += slotIdBuf.length, slotLockStatus.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += slotLockStatus.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public byte[] createSortCmdWithCarID(SortInfo sortInfo) {
        int slotsNum = sortInfo.getSlotsList().size();
        int bufferLen = 28 + 2 * slotsNum;
        byte[] replyBuffer = new byte[bufferLen];
        try {
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{7};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            int carId = Integer.parseInt(sortInfo.getCarId());
            byte[] carIdBuf = new byte[2];
            FrameUtils.getInstance().setShortBigEndian(0, carId, carIdBuf);
            System.arraycopy(carIdBuf, 0, replyBuffer, position += command.length, carIdBuf.length);
            int obr = sortInfo.getObr();
            byte[] obrBuf = new byte[]{(byte)obr};
            System.arraycopy(obrBuf, 0, replyBuffer, position += carIdBuf.length, obrBuf.length);
            byte[] siteCodeBuf = new byte[2];
            int siteCodeValue = sortInfo.getSiteCodeValue();
            FrameUtils.getInstance().setShortBigEndian(0, siteCodeValue, siteCodeBuf);
            System.arraycopy(siteCodeBuf, 0, replyBuffer, position += obrBuf.length, siteCodeBuf.length);
            byte[] slotsNumBuffer = new byte[]{(byte)slotsNum};
            System.arraycopy(slotsNumBuffer, 0, replyBuffer, position += siteCodeBuf.length, slotsNumBuffer.length);
            position += slotsNumBuffer.length;
            for (int slot : sortInfo.getSlotsList()) {
                byte[] slotBuf = new byte[2];
                FrameUtils.getInstance().setShortBigEndian(0, slot, slotBuf);
                System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                position += slotBuf.length;
            }
            int sortMode = 0;
            try {
                sortMode = Integer.parseInt(sortInfo.getSortMode());
            }
            catch (Exception e) {
                sortMode = 0;
            }
            byte[] sortModeBuf = new byte[]{(byte)sortMode};
            System.arraycopy(sortModeBuf, 0, replyBuffer, position, sortModeBuf.length);
            byte[] svrErrorCodeBuff = new byte[]{(byte)sortInfo.getErrorCodeSVR()};
            System.arraycopy(svrErrorCodeBuff, 0, replyBuffer, position += sortModeBuf.length, svrErrorCodeBuff.length);
            byte[] timeStampBuffer = this.createSystemTimeToBuffer();
            System.arraycopy(timeStampBuffer, 0, replyBuffer, position += svrErrorCodeBuff.length, timeStampBuffer.length);
            byte[] finalByte = new byte[]{1};
            System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
            position += replayEnder.length;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortCommandManager.createSortInfoBuffer] Create Sort Info Buffer Error -- Exception : " + ex);
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public byte[] createSortCmdWithPlat(SortInfo sortInfo) {
        String barcode = sortInfo.getBarcode();
        if (barcode == null) {
            barcode = "NoneCode";
        }
        int slotsNum = sortInfo.getSlotsList().size();
        int barcodeLen = barcode.length();
        int bufferLen = 28 + barcodeLen + 2 * slotsNum;
        byte[] replyBuffer = new byte[bufferLen];
        try {
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{4};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            byte[] platId = new byte[]{(byte)Integer.parseInt(sortInfo.getPlatId())};
            System.arraycopy(platId, 0, replyBuffer, position += command.length, platId.length);
            byte[] platMode = new byte[]{3};
            System.arraycopy(platMode, 0, replyBuffer, position += platId.length, platMode.length);
            byte[] barcodeLenBuf = new byte[]{(byte)barcodeLen};
            System.arraycopy(barcodeLenBuf, 0, replyBuffer, position += platMode.length, barcodeLenBuf.length);
            byte[] barcodeBuf = barcode.getBytes();
            System.arraycopy(barcodeBuf, 0, replyBuffer, position += barcodeLenBuf.length, barcodeBuf.length);
            byte[] siteCodeBuf = new byte[2];
            int siteCodeValue = sortInfo.getSiteCodeValue();
            FrameUtils.getInstance().setShortBigEndian(0, siteCodeValue, siteCodeBuf);
            System.arraycopy(siteCodeBuf, 0, replyBuffer, position += barcodeBuf.length, siteCodeBuf.length);
            byte[] slotsNumBuf = new byte[]{(byte)slotsNum};
            System.arraycopy(slotsNumBuf, 0, replyBuffer, position += siteCodeBuf.length, slotsNumBuf.length);
            position += slotsNumBuf.length;
            for (int slot : sortInfo.getSlotsList()) {
                byte[] slotBuf = new byte[2];
                FrameUtils.getInstance().setShortBigEndian(0, slot, slotBuf);
                System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                position += slotBuf.length;
            }
            int sortMode = 0;
            try {
                sortMode = Integer.parseInt(sortInfo.getSortMode());
            }
            catch (Exception e) {
                sortMode = 0;
            }
            byte[] sortModeBuf = new byte[]{(byte)sortMode};
            System.arraycopy(sortModeBuf, 0, replyBuffer, position, sortModeBuf.length);
            byte[] svrErrorCodeBuff = new byte[]{(byte)sortInfo.getErrorCodeSVR()};
            System.arraycopy(svrErrorCodeBuff, 0, replyBuffer, position += sortModeBuf.length, svrErrorCodeBuff.length);
            byte[] scannedTimeBuffer = this.createSystemTimeToBuffer();
            System.arraycopy(scannedTimeBuffer, 0, replyBuffer, position += svrErrorCodeBuff.length, scannedTimeBuffer.length);
            byte[] finalByte = new byte[]{1};
            System.arraycopy(finalByte, 0, replyBuffer, position += scannedTimeBuffer.length, finalByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
            position += replayEnder.length;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortProtocolCreator.createSortInfoWithPlat] Create Sort Info Buffer Error -- Exception : " + ex);
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public String createSortInfo(SortInfo sortInfo) {
        JSONObject requestObj = new JSONObject();
        requestObj.put("Guid", sortInfo.getUuid());
        requestObj.put("Barcodes", sortInfo.getBarcodeList());
        requestObj.put("MachineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("Weight", 0);
        requestObj.put("Length", sortInfo.getLength());
        requestObj.put("Width", sortInfo.getWidth());
        requestObj.put("Height", sortInfo.getHeight());
        requestObj.put("Obr", sortInfo.getObr());
        requestObj.put("PlatId", Integer.parseInt(sortInfo.getPlatId()));
        Timestamp requestTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
        requestObj.put("RequestTime", requestTime.toString());
        return requestObj.toString();
    }

    public String createPacketOffRequest(SortInfo sortInfo) {
        JSONObject requestObj = new JSONObject();
        requestObj.put("Guid", sortInfo.getUuid());
        requestObj.put("machineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("ChuteCode", sortInfo.getDroppedSlotId());
        requestObj.put("TurnNumber", Integer.parseInt(sortInfo.getTurnNumber()));
        requestObj.put("PacketOffTime", sortInfo.getTimestampPacketOff());
        requestObj.put("PacketOnTime", sortInfo.getTimestampPacketOn());
        Timestamp requestTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
        requestObj.put("RequestTime", requestTime);
        return requestObj.toString();
    }

    public String createSortResult(SortResult sortResult) {
        if (sortResult == null || sortResult.getSortInfos().size() == 0) {
            return null;
        }
        JSONObject requestObj = new JSONObject();
        requestObj.put("boxCode", sortResult.getBoxCode());
        requestObj.put("machineCode", SorterParams.getInstance().getMachineCode());
        requestObj.put("opCode", 21);
        requestObj.put("chuteCode", sortResult.getSlotId());
        LinkedList<JSONObject> packageCodes = new LinkedList<JSONObject>();
        for (SortInfo sortInfo : sortResult.getSortInfos()) {
            JSONObject packObjs = new JSONObject();
            packObjs.put("packageCode", sortInfo.getBarcode());
            packObjs.put("createTime", sortInfo.getTimePacketOff());
            packObjs.put("weight", 0);
            packObjs.put("length", 0);
            packObjs.put("width", 0);
            packObjs.put("height", 0);
            packageCodes.add(packObjs);
        }
        requestObj.put("packageCodes", packageCodes);
        return requestObj.toString();
    }

    public byte[] createSystemTimeToBuffer() {
        byte[] timeBuffer = new byte[8];
        long now = System.currentTimeMillis();
        FrameUtils.getInstance().setLongBigEndian(0, now, timeBuffer);
        return timeBuffer;
    }

    public void doSendTshSlotsToPLC(List<Integer> tshSlots, int tshValue) {
        try {
            Channel[] channels;
            if (tshSlots == null) {
                return;
            }
            int factualSize = tshSlots.size();
            int bufferSize = 20 + 2 * factualSize;
            byte[] replyBuffer = new byte[bufferSize];
            int position = 0;
            byte[] header = SortCommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{-16};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            byte[] tshVlaueBuf = new byte[]{(byte)tshValue};
            System.arraycopy(tshVlaueBuf, 0, replyBuffer, position += command.length, tshVlaueBuf.length);
            int slotCount = tshSlots.size();
            byte[] slotCountBuf = new byte[]{(byte)slotCount};
            System.arraycopy(slotCountBuf, 0, replyBuffer, position += tshVlaueBuf.length, slotCountBuf.length);
            position += slotCountBuf.length;
            for (int slot : tshSlots) {
                byte[] slotBuf = new byte[2];
                FrameUtils.getInstance().setShortBigEndian(0, slot, slotBuf);
                System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                position += slotBuf.length;
            }
            byte[] timeBuffer = FrameUtils.getInstance().createSystemTimeToBuffer();
            System.arraycopy(timeBuffer, 0, replyBuffer, position, timeBuffer.length);
            byte[] serialByte = new byte[]{1};
            System.arraycopy(serialByte, 0, replyBuffer, position += timeBuffer.length, serialByte.length);
            byte[] replayEnder = SortCommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += serialByte.length, replayEnder.length);
            position += replayEnder.length;
            for (Channel tmpChannel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(tmpChannel, replyBuffer, false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SortProtocolCreator.doSendTshSlotsToPLC] Send sort plan items error:");
        }
    }

    public void init() {
        this.initErrorCodeMap();
    }

    public void sendContentEchoToPLC(byte[] content) {
        Channel[] channels;
        if (content == null || content.length < 2) {
            return;
        }
        content[0] = 2;
        content[1] = 1;
        for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(channel, content, false);
        }
    }

    public void shutdown() {
    }

    private String addScanExpType(Integer errorCode) {
        String errorCodeDesc = "none";
        if (this.errorCodesMap.containsKey(errorCode)) {
            errorCodeDesc = this.errorCodesMap.get(errorCode);
        }
        return errorCodeDesc;
    }

    private String addScanObrNo(SortInfo sortInfo) {
        return String.valueOf(sortInfo.getObr());
    }

    private String addScanSupplyType(SortInfo sortInfo) {
        String supplyType = "none";
        String scannedMode = sortInfo.getScannedMode();
        String scannedPlatType = sortInfo.getScannedPlatType();
        if (scannedMode != null && scannedMode.equals("OBR")) {
            supplyType = "AT";
        } else if (scannedPlatType != null) {
            if (scannedPlatType.equals("auto")) {
                supplyType = "MB";
            } else if (scannedPlatType.equals("manual")) {
                supplyType = "MD";
            } else if (scannedPlatType.equals("reject")) {
                supplyType = "MJ";
            }
        }
        return supplyType;
    }

    private void initErrorCodeMap() {
        this.errorCodesMap.put(0, "SC");
        this.errorCodesMap.put(1, "DE");
        this.errorCodesMap.put(2, "ID");
        this.errorCodesMap.put(3, "NR");
        this.errorCodesMap.put(4, "MB");
        this.errorCodesMap.put(5, "MR");
        this.errorCodesMap.put(6, "UP");
        this.errorCodesMap.put(7, "MT");
        this.errorCodesMap.put(8, "IB");
        this.errorCodesMap.put(17, "MJ");
    }

    public String createAsynTimeContent(String lineCode) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("lineCode", lineCode);
        return requestObject.toString();
    }

    public int getDepponErrorCode(int errorCode) {
        int resCode = errorCode;
        switch (errorCode) {
            case 1: {
                resCode = 988;
                break;
            }
            case 2: {
                resCode = 988;
                break;
            }
            case 3: {
                resCode = 997;
                break;
            }
            case 4: {
                resCode = 989;
                break;
            }
            case 5: {
                resCode = 993;
                break;
            }
            case 7: {
                resCode = 993;
                break;
            }
            case 8: {
                resCode = 991;
            }
        }
        return resCode;
    }

    public String getDepponErrorDesc(int errorCode) {
        String strRes = "\u6210\u529f";
        switch (errorCode) {
            case 997: {
                strRes = "\u672a\u8bc6\u522b";
                break;
            }
            case 996: {
                strRes = "\u975e\u5fb7\u90a6\u9762\u5355";
                break;
            }
            case 995: {
                strRes = "\u5305\u5185\u8d85\u91cd\u4e14\u8d85\u8fc7\u6700\u5927\u5faa\u73af";
                break;
            }
            case 994: {
                strRes = "\u5305\u5185\u8d85\u6570\u4e14\u8d85\u8fc7\u6700\u5927\u5faa\u73af";
                break;
            }
            case 993: {
                strRes = "\u683c\u53e3\u5173\u95ed\u4e14\u8d85\u8fc7\u6700\u5927\u5faa\u73af";
                break;
            }
            case 992: {
                strRes = "\u8865\u7801\u4e0d\u53ca\u65f6\u4e14\u8d85\u8fc7\u6700\u5927\u5faa\u73af";
                break;
            }
            case 991: {
                strRes = "\u5305\u88f9\u8d85\u8fc7\u4e86\u8fb9\u754c\uff08IOB\uff09";
                break;
            }
            case 990: {
                strRes = "\u8bf7\u6c42\u8d85\u65f6";
                break;
            }
            case 989: {
                strRes = "\u591a\u4e2a\u6761\u7801";
                break;
            }
            case 988: {
                strRes = "\u65e0\u683c\u53e3\u4fe1\u606f";
                break;
            }
            case 987: {
                strRes = "\u65e0\u8def\u7531\u4fe1\u606f";
            }
        }
        return strRes;
    }

    public String getColorLight() {
        String res = "{\n  \"Programs\": {\n    \"Program\": {\n\t\t\"Information\":{  \n\t\t\t\"Width\":\"256\",\n\t\t\t\"Height\":\"192\"\n\t\t\t},\n      \"Pages\": [{\n          \"Regions\": [\n              {\n\t\t\t    \"Layer\":1,\n                \"Rect\": {\n                  \"X\": \"0\",\n                  \"Y\": \"0\",\n                  \"Width\": \"128\",\n                  \"Height\": \"64\"\n                },\n                \"Items\": [{\n                    \"Name\": \"Multiple line text.\",\n                    \"Type\": \"5\",\n                    \"Version\": \"0x00000001\",\n                    \"BackColor\": \"black\",\n                    \"Alpha\": \"1.000000\",\n                    \"Duration\": \"94480\",\n                    \"BeGlaring\": \"0\",\n                    \"MultiPicInfo\": {\n                      \"OnePicDuration\": \"6000\"\n                    },\n                    \"TextColor\": \"0xFFFFFFFF\",\n                    \"LogFont\": {\n                      \"lfHeight\": \"12\",\n                      \"lfWeight\": \"0\",\n                      \"lfItalic\": \"0\",\n                      \"lfUnderline\": \"0\",\n                      \"lfStrikeOut\": \"0\",\n                      \"lfFaceName\": \"\u5b8b\u4f53\" \n                    },\n                    \"RepeatCount\": \"1\",\n                    \"Speed\": \"60.000000\",\n                    \"IsHeadConnectTail\": \"1\",\n                    \"IsScroll\": \"0\",\n                    \"PlayLenth\": \"300000\",\n\t\t\t\t\t\"lineSpacingExtra\":0.0,\n\t\t\t\t\t\"lineSpacingMultiplier\":1.1,\n\t\t\t\t\t\"VerticalAlign\":0,            \n\t\t\t\t\t\"CenteralAlign\":0,           \n                    \"Text\": \"\u65e5\u671f:2020-09-10\\n\u4f9b\u4ef6\u6548\u7387:1800/h\\n\u5254\u9664\u4ef6\u6570\u91cf:22\\n\u5f53\u524d\u91cd\u91cf:3.3\" \n\t\t\t\t}]\n              },\n              {\n\t\t\t    \"Layer\":2,\n                \"Rect\": {\n                  \"X\": \"128\",\n                  \"Y\": \"0\",\n                  \"Width\": \"128\",\n                  \"Height\": \"64\"\n                },\n                \"Items\": [{\n                 \t\"Type\": \"5\",\n\t\t\t\t\t\"Text\": \"Multi lines.\",\n\t\t\t\t\t\"LogFont\": {\n                      \"lfHeight\": \"36\",\n                      \"lfWidth\": \"0\"\n                    }\n\t\t\t\t}]\n              }            \n            ]\n\t\t}]\n    }\n  }\n}";
        return res;
    }

    private static class SortProtocolManagerHolder {
        private static final SortProtocolCreator INSTANCE = new SortProtocolCreator();

        private SortProtocolManagerHolder() {
        }
    }
}

