/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.log.LogUtil;
import com.simba.server.components.data.EmergencyStopInfo;
import com.simba.server.components.data.PacketOnInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IComplementController;
import com.simba.server.controllers.IEmergencyStopController;
import com.simba.server.controllers.IPacketOffController;
import com.simba.server.controllers.IPacketOnController;
import com.simba.server.controllers.IPlatScannedController;
import com.simba.server.controllers.ISlotPackController;
import com.simba.server.controllers.ISlotUnlockController;
import com.simba.server.controllers.ISortInfoController;
import com.simba.server.controllers.impl.DepponComplementController;
import com.simba.server.controllers.impl.DepponEmergencyStopController;
import com.simba.server.controllers.impl.DepponPacketOffController;
import com.simba.server.controllers.impl.DepponPacketOnController;
import com.simba.server.controllers.impl.DepponPlatScannedController;
import com.simba.server.controllers.impl.DepponSlotPackController;
import com.simba.server.controllers.impl.DepponSlotUnlockController;
import com.simba.server.controllers.impl.DepponSortInfoController;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SortControllerManager
implements IPacketOnController,
IPacketOffController,
IPlatScannedController,
ISlotPackController,
ISlotUnlockController,
IComplementController,
ISortInfoController,
IEmergencyStopController {
    private static final Logger logger = Logger.getLogger(SortControllerManager.class);
    private static final String SORT_INFO_MODE_ONLINE = "Online-Sorter-Mode";
    private final HashMap<String, IComplementController> complementControllers = new HashMap();
    private String currentSortInfoMode;
    private final HashMap<String, IPacketOffController> packetOffControllers = new HashMap();
    private final HashMap<String, IPacketOnController> packetOnControllers = new HashMap();
    private final HashMap<String, IPlatScannedController> platMESControllers = new HashMap();
    private final HashMap<String, ISlotPackController> slotPackControllers = new HashMap();
    private final HashMap<String, ISlotUnlockController> slotUnlockControllers = new HashMap();
    private final HashMap<String, ISortInfoController> sortInfoControllers = new HashMap();
    private final HashMap<String, IEmergencyStopController> emergencyStopControllers = new HashMap();

    public static SortControllerManager getInstance() {
        return SortBusinessManagerHolder.INSTANCE;
    }

    private SortControllerManager() {
    }

    public String getCurrentSortInfoMode() {
        return this.currentSortInfoMode;
    }

    public void init() {
        try {
            this.currentSortInfoMode = SORT_INFO_MODE_ONLINE;
            this.initPacketOnControllers();
            this.initSortInfoControllers();
            this.initPlatMESControllers();
            this.initPacketOffControllers();
            this.initSlotPackControllers();
            this.initSlotUnlockControllers();
            this.initComplementControllers();
            this.initEmergencyStopControllers();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Init Sort Business Manager Error -- Exception : " + ex);
        }
    }

    @Override
    public void onComplementMessage(SortInfo sortInfo) {
        IComplementController controller = this.complementControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onComplementMessage(sortInfo);
        }
    }

    @Override
    public void onPacketOffMessage(SortInfo sortInfo) {
        IPacketOffController controller = this.packetOffControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onPacketOffMessage(sortInfo);
        }
    }

    @Override
    public void onPacketOnMessage(PacketOnInfo packetOnInfo) {
        IPacketOnController controller = this.packetOnControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onPacketOnMessage(packetOnInfo);
        }
    }

    @Override
    public void onPlatScannedMessage(SortInfo sortInfo) {
        IPlatScannedController controller = this.platMESControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onPlatScannedMessage(sortInfo);
        }
    }

    @Override
    public void onSlotPackMessage(SlotInfo slotInfo) {
        ISlotPackController controller = this.slotPackControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotPackMessage(slotInfo);
        }
    }

    @Override
    public void onSlotUnlockMessage(SlotInfo slotInfo) {
        ISlotUnlockController controller = this.slotUnlockControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotUnlockMessage(slotInfo);
        }
    }

    @Override
    public void onSortInfoMessage(SortInfo sortInfo) {
        ISortInfoController controller = this.sortInfoControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSortInfoMessage(sortInfo);
        }
    }

    @Override
    public void onEmergencyStopMessage(EmergencyStopInfo emergencyStopInfo) {
        IEmergencyStopController controller = this.emergencyStopControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onEmergencyStopMessage(emergencyStopInfo);
        }
    }

    public void shutdown() {
    }

    private void initComplementControllers() {
        this.complementControllers.put(SORT_INFO_MODE_ONLINE, new DepponComplementController());
    }

    private void initPacketOffControllers() {
        this.packetOffControllers.put(SORT_INFO_MODE_ONLINE, new DepponPacketOffController());
    }

    private void initPacketOnControllers() {
        this.packetOnControllers.put(SORT_INFO_MODE_ONLINE, new DepponPacketOnController());
    }

    private void initPlatMESControllers() {
        this.platMESControllers.put(SORT_INFO_MODE_ONLINE, new DepponPlatScannedController());
    }

    private void initSlotPackControllers() {
        this.slotPackControllers.put(SORT_INFO_MODE_ONLINE, new DepponSlotPackController());
    }

    private void initSlotUnlockControllers() {
        this.slotUnlockControllers.put(SORT_INFO_MODE_ONLINE, new DepponSlotUnlockController());
    }

    private void initSortInfoControllers() {
        this.sortInfoControllers.put(SORT_INFO_MODE_ONLINE, new DepponSortInfoController());
    }

    private void initEmergencyStopControllers() {
        this.emergencyStopControllers.put(SORT_INFO_MODE_ONLINE, new DepponEmergencyStopController());
    }

    private static class SortBusinessManagerHolder {
        private static final SortControllerManager INSTANCE = new SortControllerManager();

        private SortBusinessManagerHolder() {
        }
    }
}

