/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.ServerManager;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.MachineParams;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.TrashSlotInfo;
import com.simba.server.components.data.VideoSortInfo;
import com.simba.server.task.BoxInfoAllocTask;
import com.simba.server.task.SlotStatusTask;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotManager {
    public static final int NORMAL_SLOT_0 = 0;
    public static final int TRASH_SLOT_1_NO_INFO = 1;
    public static final int TRASH_SLOT_2_NO_READ = 2;
    public static final int TRASH_SLOT_15_JD_SVR_EXP120 = 15;
    public static final int TRASH_SLOT_16_JD_SVR_EXP130 = 16;
    public static final int TRASH_SLOT_18_INVALID_CODE_ERROR = 18;
    public static final int TRASH_SLOT_2_NO_PLAN = 2;
    public static final int TRASH_SLOT_3_NO_READ = 3;
    public static final int TRASH_SLOT_4_MULTI_BARCODE = 4;
    public static final int TRASH_SLOT_5_MAX_CIRCLE = 5;
    public static final int TRASH_SLOT_6_LOST_PACKET = 6;
    public static final int TRASH_SLOT_7_OVER_TIME = 7;
    public static final int TRASH_SLOT_8_IBB_ERROR = 8;
    public static final int TRASH_SLOT_9_JD_SVR_INTER_ERROR = 9;
    private static final Logger logger = Logger.getLogger(SlotManager.class);
    private final BoxInfoAllocTask boxInfoAllocTask = new BoxInfoAllocTask();
    private final List<Integer> exp120TrashSlotList = new ArrayList<Integer>();
    private final List<Integer> exp130TrashSlotList = new ArrayList<Integer>();
    private final List<Integer> ibbErrorTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> invalidCodeTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> jdSvrErrorTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> lostPackTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> maxCircleTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> multiCodeTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> noInfoTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> noPlanTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> noReadTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> overTimeTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> noSlotInfoTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> packetOverBoarderTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> complementOverTimeAndOverMaxTimesTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> slotLockAndOverMaxTimesTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> warnSumAndOverMaxTimesTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> warnWeightAndOverMaxTimesTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> notDepponWayBillTrashSlotList = new ArrayList<Integer>();
    private final ConcurrentHashMap<String, SlotInfo> slotInfoList = new ConcurrentHashMap();
    private byte[] slotLockStatus;
    private final SlotStatusTask slotStatusTask = new SlotStatusTask();
    private final ConcurrentHashMap<String, SlotInfo> trashSlotList = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, VideoSortInfo> videoSortInfos = new ConcurrentHashMap();

    public static SlotManager getInstance() {
        return SlotManagerHolder.INSTANCE;
    }

    private SlotManager() {
    }

    public void addSlotInfo(SlotInfo slotInfo) {
        if (slotInfo != null) {
            this.slotInfoList.put(slotInfo.getSlotId(), slotInfo);
        }
    }

    public Boolean checkSlotIsTrash(String slotId) {
        Boolean ret = false;
        if (this.trashSlotList.containsKey(slotId)) {
            ret = true;
        }
        return ret;
    }

    public void clearSlotInfoList() {
        this.slotInfoList.clear();
    }

    public boolean containsSlotInfo(String key) {
        return this.slotInfoList.containsKey(key);
    }

    public String createSlotBindUUID() {
        return "";
    }

    public Boolean doAllocAllBoxInfo() {
        Boolean ret = false;
        SlotInfo slotInfo = new SlotInfo();
        ICommand command = CommandCreator.getInstance().createCommand("WebPackageNoCmd", slotInfo);
        ret = WebCommandExecutor.getInstance().executeCmd(command);
        if (!ret.booleanValue()) {
            LogUtil.LogDebug(logger, "[SlotManager.doAllocAllBoxInfo] Fetch all  Box Info Failed]");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean doAllocBoxInfo(SlotInfo slotInfo) {
        Boolean ret = false;
        SlotInfo slotInfo2 = slotInfo;
        synchronized (slotInfo2) {
            int requestTime;
            for (requestTime = 0; !ret.booleanValue() && requestTime < 3; ++requestTime) {
                ICommand command = CommandCreator.getInstance().createCommand("WebPackageNoCmd", slotInfo);
                ret = WebCommandExecutor.getInstance().executeCmd(command);
            }
            if (requestTime > 1) {
                LogUtil.LogDebug(logger, "[SlotManager.doAllocBoxInfo] Fetch Box Info Times " + requestTime + ", SlotId : [" + slotInfo.getSlotId() + "] ret=" + ret);
            }
            if (!ret.booleanValue()) {
                LogUtil.LogDebug(logger, "[SlotManager.doAllocBoxInfo] Fetch Box Info Failed, SlotId : [" + slotInfo.getSlotId() + "]");
                slotInfo.resetBoxInfo();
            } else {
                slotInfo.setAllocBoxInfo(true);
                this.recordNewBoxInfo(slotInfo);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAllocBoxInfoOneSlot(SlotInfo slotInfo) {
        SlotInfo slotInfo2 = slotInfo;
        synchronized (slotInfo2) {
            if (slotInfo.getAllocBoxInfo().booleanValue()) {
                LogUtil.LogDebug(logger, "[slotInfo.getAllocBoxInfo() is true, SlotId : [" + slotInfo.getSlotId() + "]");
                slotInfo.setLockStatus(0);
                this.setSlotSoftLockStatus(slotInfo);
                this.sendSlotSoftUnLockToPLC(slotInfo);
                return;
            }
            ICommand command = CommandCreator.getInstance().createCommand("WebPackageNoCmd", slotInfo);
            Boolean ret = WebCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                LogUtil.LogDebug(logger, "[SlotManager.doAllocBoxInfoLocal] Fetch Box Info Failed, SlotId : [" + slotInfo.getSlotId() + "]");
                slotInfo.resetBoxInfo();
            } else {
                slotInfo.setAllocBoxInfo(true);
                slotInfo.setLockStatus(0);
                this.setSlotSoftLockStatus(slotInfo);
                this.sendSlotSoftUnLockToPLC(slotInfo);
                LogUtil.LogDebug(logger, "[doAllocBoxInfoLocal]:BoxCode:[" + slotInfo.getBoxInfo().getBoxCode() + "],SlotId:[" + slotInfo.getSlotId() + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSendSlotStatus(SlotInfo slotInfo, int slotStatus) {
        SlotInfo slotInfo2 = slotInfo;
        synchronized (slotInfo2) {
            ICommand command = CommandCreator.getInstance().createCommand("WebSlotStatusCmd", slotInfo);
            Boolean ret = WebCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                LogUtil.LogDebug(logger, "[SlotManager.doSendSlotStatus] doSendSlotStatus Failed, SlotId : [" + slotInfo.getSlotId() + "]");
                slotInfo.resetBoxInfo();
            } else {
                if (slotStatus == 0) {
                    slotInfo.setLockStatus(0);
                } else {
                    slotInfo.setLockStatus(1);
                }
                this.setSlotSoftLockStatus(slotInfo);
                LogUtil.LogDebug(logger, "[doSendSlotStatus]:BoxCode:[" + slotInfo.getBoxInfo().getBoxCode() + "],SlotId:[" + slotInfo.getSlotId() + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAllocBoxInfoLocal(SlotInfo slotInfo) {
        SlotInfo slotInfo2 = slotInfo;
        synchronized (slotInfo2) {
            if (slotInfo.getAllocBoxInfo().booleanValue()) {
                slotInfo.setLockStatus(0);
                this.setSlotSoftLockStatus(slotInfo);
                this.sendSlotSoftUnLockToPLC(slotInfo);
                return;
            }
            ICommand command = CommandCreator.getInstance().createCommand("WebPackageNoCmd", slotInfo);
            Boolean ret = WebCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                LogUtil.LogDebug(logger, "[SlotManager.doAllocBoxInfoLocal] Fetch Box Info Failed, SlotId : [" + slotInfo.getSlotId() + "]");
                slotInfo.resetBoxInfo();
            } else {
                slotInfo.setAllocBoxInfo(true);
                slotInfo.setLockStatus(0);
                this.setSlotSoftLockStatus(slotInfo);
                this.sendSlotSoftUnLockToPLC(slotInfo);
                LogUtil.LogDebug(logger, "[doAllocBoxInfoLocal]:BoxCode:[" + slotInfo.getBoxInfo().getBoxCode() + "],SlotId:[" + slotInfo.getSlotId() + "]");
            }
        }
    }

    public void doSetAllTrashSlots(TrashSlotInfo trashSlotInfo) {
        this.truncateTrashSlot();
        this.recordTrashSlots(trashSlotInfo);
        List<Integer> configTrashSlots = trashSlotInfo.getTrashSlots();
        if (configTrashSlots != null && configTrashSlots.size() > 0) {
            this.trashSlotList.clear();
            this.setNoInfoTrashSlots(configTrashSlots);
            this.setNoPlanTrashSlots(configTrashSlots);
            this.setNoReadTrashSlots(configTrashSlots);
            this.setInvalidCodeTrashSlots(configTrashSlots);
            this.registerTrashSlot(configTrashSlots);
        }
    }

    private void truncateTrashSlot() {
        try {
            String tableName = "tt_trash_slots";
            ICommand command = CommandCreator.getInstance().createCommand("TruncateTableCmd", tableName);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recordTrashSlots(TrashSlotInfo trashSlotInfo) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("RecordTrashSlotsInfoCmd", trashSlotInfo);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doGetTrashSlots(TrashSlotInfo trashSlotInfo) {
        List<Integer> configTrashSlots;
        int trashType = trashSlotInfo.getTypeId();
        ICommand command = CommandCreator.getInstance().createCommand("FetchTrashSlotsCmd", trashSlotInfo);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue() && (configTrashSlots = trashSlotInfo.getTrashSlots()) != null && configTrashSlots.size() > 0) {
            switch (trashType) {
                case 2: {
                    this.setNoPlanTrashSlots(configTrashSlots);
                    break;
                }
                case 3: {
                    this.setNoReadTrashSlots(configTrashSlots);
                    break;
                }
            }
            this.registerTrashSlot(configTrashSlots);
        }
    }

    public String getChuteCodeFromSlotId(int i) {
        String chuteCode = "0";
        if (i < 10) {
            chuteCode = chuteCode + "00" + String.valueOf(i);
        } else if (i >= 10 && i < 100) {
            chuteCode = chuteCode + "0" + String.valueOf(i);
        } else if (i >= 100) {
            chuteCode = chuteCode + String.valueOf(i);
        }
        return chuteCode;
    }

    public List<Integer> getEXP120TrashSlots() {
        return this.exp120TrashSlotList;
    }

    public List<Integer> getEXP130TrashSlots() {
        return this.exp130TrashSlotList;
    }

    public List<Integer> getIBBErrorTrashSlots() {
        return this.ibbErrorTrashSlotList;
    }

    public List<Integer> getInvalidCodeTrashSlots() {
        return this.invalidCodeTrashSlotList;
    }

    public List<Integer> getJDSvrErrorTrashSlots() {
        return this.jdSvrErrorTrashSlotList;
    }

    public List<Integer> getLostPackTrashSlots() {
        return this.lostPackTrashSlotList;
    }

    public List<Integer> getMaxCircleTrashSlots() {
        return this.maxCircleTrashSlotList;
    }

    public List<Integer> getMultiCodeTrashSlots() {
        return this.multiCodeTrashSlotList;
    }

    public List<Integer> getNoInfoTrashSlots() {
        return this.noInfoTrashSlotList;
    }

    public List<Integer> getNoPlanTrashSlots() {
        return this.noPlanTrashSlotList;
    }

    public List<Integer> getNoReadTrashSlots() {
        return this.noReadTrashSlotList;
    }

    public List<Integer> getOverTimeTrashSlots() {
        return this.overTimeTrashSlotList;
    }

    public List<Integer> getNoSlotInfoTrashSlots() {
        return this.noSlotInfoTrashSlotList;
    }

    public List<Integer> getPacketOverBoarderTrashSlots() {
        return this.packetOverBoarderTrashSlotList;
    }

    public List<Integer> getComplementOverTimeAndOverMaxTimesTrashSlots() {
        return this.complementOverTimeAndOverMaxTimesTrashSlotList;
    }

    public List<Integer> getSlotLockAndOverMaxTimesTrashSlots() {
        return this.slotLockAndOverMaxTimesTrashSlotList;
    }

    public List<Integer> getWarnSumAndOverMaxTimesTrashSlots() {
        return this.warnSumAndOverMaxTimesTrashSlotList;
    }

    public List<Integer> getWarnWeightAndOverMaxTimesTrashSlots() {
        return this.warnWeightAndOverMaxTimesTrashSlotList;
    }

    public List<Integer> getNotDepponWayBillTrashSlots() {
        return this.notDepponWayBillTrashSlotList;
    }

    public int getSlotIdFromChuteCode(String chuteCode) {
        String slotIdContent = chuteCode.substring(1);
        int slotIdValue = Integer.parseInt(slotIdContent);
        return slotIdValue;
    }

    public SlotInfo getSlotInfo(String key) {
        return this.slotInfoList.get(key.toLowerCase());
    }

    public int getSlotInfoCount() {
        return this.slotInfoList.size();
    }

    public SlotInfo[] getSlotInfoList() {
        return this.slotInfoList.values().toArray(new SlotInfo[0]);
    }

    public byte[] getSlotLockStatus() {
        return this.slotLockStatus;
    }

    public void init() {
        try {
            int slotSize = SorterParams.getInstance().getSlotNumber();
            this.slotLockStatus = new byte[slotSize];
            for (int i = 0; i < this.slotLockStatus.length; ++i) {
                this.slotLockStatus[i] = 1;
            }
            this.initSlotInfos();
            this.initTasks();
            this.doAllocAllBoxInfo();
            this.reloadTshSlots();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "init slot info  error: " + ex);
        }
    }

    public void initTrashSlots() {
        this.trashSlotList.clear();
        this.initNoPlanTrashSlot();
        this.initNoReadTrashSlot();
        this.initOverTimeTrashSlot();
    }

    public void offerSlotPackToRestore(SlotInfo slotInfo) {
        try {
            SlotInfo newSlotInfo = new SlotInfo();
            newSlotInfo.cloneSlotInfo(slotInfo);
            ServerManager.getInstance().getDataRestoreTask().offerRestoreDataToQueue(newSlotInfo);
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "offer slot info to restore: " + e.getMessage());
        }
    }

    public void parseSlotFromBarcode(SortInfo sortInfo) {
        try {
            String barcode = sortInfo.getBarcode();
            String[] info = barcode.split("-");
            if (info.length < 4) {
                int errorCode = 13;
                sortInfo.setErrorCodeSVR(errorCode);
                sortInfo.getSlotsList().clear();
                sortInfo.getChuteCodeList().clear();
            } else {
                sortInfo.getSlotsList().clear();
                sortInfo.getChuteCodeList().clear();
                String slotIdKey = info[3];
                SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotIdKey);
                String boxCode = slotInfo.getBoxInfo().getBoxCode();
                if (boxCode != null && !boxCode.equals("")) {
                    sortInfo.getSlotsList().add(Integer.parseInt(slotIdKey));
                }
            }
        }
        catch (Exception e) {
            int errorCode = 13;
            sortInfo.setErrorCodeSVR(errorCode);
            sortInfo.getSlotsList().clear();
            sortInfo.getChuteCodeList().clear();
            LogUtil.LogError(logger, "parse slot from barcode error: " + e.getMessage());
        }
    }

    public void postInitProcess() {
    }

    public void printEXP120TrashSlot() {
        String info = "EXP 120 Trash slots : ";
        for (Integer trashSlot : this.exp120TrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printEXP130TrashSlot() {
        String info = "EXP 130 Trash slots : ";
        for (Integer trashSlot : this.exp130TrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printIBBTrashSlot() {
        String info = "IBB Error Trash slots : ";
        for (Integer trashSlot : this.ibbErrorTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printJDSvrErrorTrashSlot() {
        String info = "JD Server Trash slots : ";
        for (Integer trashSlot : this.jdSvrErrorTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printLostPacketTrashSlot() {
        String info = "Lost Pack Trash slots : ";
        for (Integer trashSlot : this.lostPackTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printMaxCircleTrashSlot() {
        String info = "Max Circle Trash slots : ";
        for (Integer trashSlot : this.maxCircleTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printMultiCodeTrashSlot() {
        String info = "Multi Code Trash slots : ";
        for (Integer trashSlot : this.multiCodeTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printNoInfoTrashSlot() {
        String info = " No Info Trash slots : ";
        for (Integer trashSlot : this.noInfoTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printNoPlanTrashSlot() {
        String info = "No Plan Trash slots : ";
        for (Integer trashSlot : this.noPlanTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printNoReadTrashSlot() {
        String info = "No Read Trash slots : ";
        for (Integer trashSlot : this.noReadTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void printOverTimeTrashSlot() {
        String info = "Over Time Trash slots : ";
        for (Integer trashSlot : this.overTimeTrashSlotList) {
            info = info + trashSlot + " ";
        }
        LogUtil.LogDebug(logger, info);
    }

    public void registerTrashSlot(List<Integer> configTrashSlots) {
        for (Integer slotValue : configTrashSlots) {
            SlotInfo slotInfo;
            String slotId = String.valueOf(slotValue);
            if (this.trashSlotList.containsKey(slotId) || (slotInfo = this.slotInfoList.get(slotId)) == null) continue;
            this.trashSlotList.put(slotId, slotInfo);
        }
    }

    public void reloadTshSlots() {
        this.initTrashSlots();
    }

    public SlotInfo removeSlotInfo(String key) {
        return this.slotInfoList.remove(key);
    }

    public void sendSlotSoftLockToPLC(SlotInfo slotInfo) {
        try {
            Channel[] channels;
            byte[] replyBuffer = SortProtocolCreator.getInstance().createSlotSoftLock(Integer.parseInt(slotInfo.getSlotId()));
            for (Channel tmpChannel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(tmpChannel, replyBuffer, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendSlotSoftUnLockToPLC(SlotInfo slotInfo) {
        try {
            Channel[] channels;
            byte[] replyBuffer = SortProtocolCreator.getInstance().createSlotSoftUnLock(Integer.parseInt(slotInfo.getSlotId()));
            for (Channel tmpChannel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(tmpChannel, replyBuffer, false);
                LogUtil.LogDebug(logger, "sendSlotSoftUnLockToPLC");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendTshSlotsToPLC() {
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.noPlanTrashSlotList, 2);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.noReadTrashSlotList, 3);
    }

    public void setSlotSoftLockStatus(SlotInfo slotInfo) {
        try {
            int slotIndex = Integer.parseInt(slotInfo.getSlotId()) - 1;
            int softLockStatus = slotInfo.getLockStatus();
            if (this.slotLockStatus == null || this.slotLockStatus.length <= slotIndex) {
                return;
            }
            this.slotLockStatus[slotIndex] = (byte)softLockStatus;
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "Update Slot Soft Lock Status Error.");
        }
    }

    private void initNoPlanTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(2);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initNoReadTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(3);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initOverTimeTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(7);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initSlotInfos() {
        this.slotInfoList.clear();
        LinkedList slots = new LinkedList();
        ICommand command = CommandCreator.getInstance().createCommand("FetchSlotInfoCmd", slots);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue()) {
            for (SlotInfo slotInfo : slots) {
                slotInfo.resetBoxInfo();
                this.slotInfoList.put(slotInfo.getSlotId(), slotInfo);
            }
        }
        this.printSlotInfos();
        SortInfoManager.getInstance().clearSiteCodeMap();
    }

    private void initTasks() {
        this.boxInfoAllocTask.start();
        this.slotStatusTask.start();
    }

    private void printSlotInfos() {
        String info = "[SlotManager.initSlotInfos] Current slot number : [" + this.slotInfoList.size() + "]";
        LogUtil.LogDebug(logger, info);
    }

    private void recordNewBoxInfo(SlotInfo slotInfo) {
        LinkedList<BoxInfo> boxInfos = new LinkedList<BoxInfo>();
        boxInfos.add(slotInfo.getBoxInfo());
        ICommand command = CommandCreator.getInstance().createCommand("RecordBoxInfoCmd", boxInfos);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private Boolean renewLocalBoxInfoStatus(SlotInfo slotInfo) {
        Boolean ret = false;
        try {
            BoxInfo boxInfo = slotInfo.getBoxInfo();
            ICommand command = CommandCreator.getInstance().createCommand("RenewBoxInfoCmd", boxInfo);
            ret = SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private void setInvalidCodeTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.invalidCodeTrashSlotList.clear();
        this.invalidCodeTrashSlotList.addAll(configTrashSlots);
    }

    private void setNoInfoTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noInfoTrashSlotList.clear();
        this.noInfoTrashSlotList.addAll(configTrashSlots);
    }

    private void setNoPlanTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noPlanTrashSlotList.clear();
        this.noPlanTrashSlotList.addAll(configTrashSlots);
    }

    private void setNoReadTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noReadTrashSlotList.clear();
        this.noReadTrashSlotList.addAll(configTrashSlots);
    }

    public void sendBasicConfigToPlc() {
        try {
            String strMaxTimes = MachineParams.getInstance().getMaxTimes();
            int maxTime = 1;
            if (strMaxTimes != null) {
                maxTime = Integer.parseInt(strMaxTimes);
            }
            MachineParams.getInstance().setMaxLoopCircle(maxTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ConcurrentHashMap<String, VideoSortInfo> getVideoSortInfos() {
        return this.videoSortInfos;
    }

    public String getSortCode(int slot) {
        String strSlot;
        String strRes = strSlot = String.valueOf(slot);
        try {
            if (strRes.length() == 1) {
                strRes = "00" + strRes;
            } else if (strRes.length() == 2) {
                strRes = "0" + strRes;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return strRes;
    }

    private static class SlotManagerHolder {
        private static final SlotManager INSTANCE = new SlotManager();

        private SlotManagerHolder() {
        }
    }
}

