/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.ServerParam;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PrinterInfoManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.DisplayInfo;
import com.simba.server.components.data.PrinterInfo;
import com.simba.server.components.data.ScreenInfo;
import com.simba.server.components.data.SlotInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ScreenInfoManager {
    private boolean isEmgerGencyInfo = false;
    protected static final Logger logger = Logger.getLogger(ScreenInfoManager.class);
    private String screenTemplete = "";
    private String stopTemplate = "";
    private Timestamp lastTime;
    private final ConcurrentHashMap<String, ScreenInfo> ScreenInfoMap = new ConcurrentHashMap();
    private Map<String, Integer> stopIds = new HashMap<String, Integer>();
    private static final ConcurrentHashMap<String, Timestamp> priorLockedSlots = new ConcurrentHashMap();
    private static final List<Integer> priorLockedList = new ArrayList<Integer>();
    private String Scheme;

    public Timestamp getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(Timestamp lastTime) {
        this.lastTime = lastTime;
    }

    public static ScreenInfoManager getInstance() {
        return ScreenManagerHolder.INSTANCE;
    }

    public Map<String, Integer> getStopIds() {
        return this.stopIds;
    }

    public void setStopIds(Map<String, Integer> stopIds) {
        this.stopIds = stopIds;
    }

    private ScreenInfoManager() {
    }

    public void addScreenInfo(ScreenInfo ScreenInfo2) {
        if (ScreenInfo2 == null || ScreenInfo2.getScreenId() == null) {
            return;
        }
        this.ScreenInfoMap.put(ScreenInfo2.getScreenId(), ScreenInfo2);
    }

    public ScreenInfo getScreenInfo(String ScreenId) {
        if (ScreenId == null || ScreenId.equals("")) {
            return null;
        }
        return this.ScreenInfoMap.get(ScreenId);
    }

    public ScreenInfo[] getScreenInfos() {
        return this.ScreenInfoMap.values().toArray(new ScreenInfo[0]);
    }

    public void loadScreens() {
        try {
            this.ScreenInfoMap.clear();
            ConcurrentHashMap screenInfo = new ConcurrentHashMap();
            ICommand command = CommandCreator.getInstance().createCommand("FetchScreenInfoCmd", screenInfo);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (ret.booleanValue()) {
                this.ScreenInfoMap.putAll(screenInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.initScreens] Init Screens info error: " + ex);
        }
    }

    public void initScreenJSonFile() {
        String jsonStr = "";
        try {
            File jsonFile = new File(ServerParam.SCREEN_JSON_FILE);
            FileReader fileReader = new FileReader(jsonFile);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
            int ch = 0;
            StringBuffer sb = new StringBuffer();
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            fileReader.close();
            ((Reader)reader).close();
            jsonStr = sb.toString();
            this.setScreenTemplete(jsonStr);
            jsonFile = new File(ServerParam.SCREEN_JSON_Template);
            fileReader = new FileReader(jsonFile);
            reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
            ch = 0;
            sb = new StringBuffer();
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            fileReader.close();
            ((Reader)reader).close();
            jsonStr = sb.toString();
            this.setStopTemplate(jsonStr);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.initScreenJSonFile] initScreenJSonFile info error: " + ex);
        }
    }

    public void sendEmgergencyInfo() {
    }

    public ScreenInfo removeScreenInfo(String ScreenId) {
        return this.ScreenInfoMap.remove(ScreenId);
    }

    public boolean isEmgerGencyInfo() {
        return this.isEmgerGencyInfo;
    }

    public void setEmgerGencyInfo(boolean isEmgergency) {
        this.isEmgerGencyInfo = isEmgergency;
    }

    public void handleEmergency(Map<String, Integer> stopSites) {
        try {
            for (Map.Entry<String, ScreenInfo> entry : this.ScreenInfoMap.entrySet()) {
                String strScreenID = entry.getKey();
                LinkedList slots = new LinkedList();
                DisplayInfo displayInfo = new DisplayInfo();
                displayInfo.getLockedSlots().addAll(slots);
                displayInfo.setDisPlayID(strScreenID);
                displayInfo.setEmgerceny(false);
                String displayMessage = this.getEmergencyDisplayMessage(stopSites);
                displayInfo.setDisPlayMessage(displayMessage);
                ICommand command = CommandCreator.getInstance().createCommand("WebColorLightCmd", displayInfo);
                boolean bl = WebCommandExecutor.getInstance().executeCmd(command);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.handleSlotLockStatus]  error: " + ex);
        }
    }

    public void handleSlotStaticStatus(List<SlotInfo> slots) {
        try {
            if (this.stopIds != null && this.stopIds.size() > 0) {
                return;
            }
            for (Map.Entry<String, ScreenInfo> entry : this.ScreenInfoMap.entrySet()) {
                String strScreenID = entry.getKey();
                DisplayInfo displayInfo = new DisplayInfo();
                LinkedList<SlotInfo> curScreenSlots = new LinkedList<SlotInfo>();
                for (int i = 0; i < slots.size(); ++i) {
                    SlotInfo slotInfo = slots.get(i);
                    slotInfo = SlotManager.getInstance().getSlotInfo(slotInfo.getSlotId());
                    if (slotInfo == null || !slotInfo.getScreenId().equalsIgnoreCase(strScreenID)) continue;
                    curScreenSlots.add(slotInfo);
                }
                if (curScreenSlots.size() <= 0) continue;
                displayInfo.getLockedSlots().addAll(curScreenSlots);
                displayInfo.setDisPlayID(strScreenID);
                displayInfo.setEmgerceny(false);
                String displayMessage = this.getSlotStaticDisplayMessage(curScreenSlots);
                displayInfo.setDisPlayMessage(displayMessage);
                ICommand command = CommandCreator.getInstance().createCommand("WebColorLightCmd", displayInfo);
                boolean bl = WebCommandExecutor.getInstance().executeCmd(command);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.handleSlotLockStatus]  error: " + ex);
        }
    }

    public void handleSlotLockStatus(List<Integer> lockedSlots) {
        try {
            if (this.stopIds != null && this.stopIds.size() > 0) {
                return;
            }
            for (Map.Entry<String, ScreenInfo> entry : this.ScreenInfoMap.entrySet()) {
                String strScreenID = entry.getKey();
                LinkedList<SlotInfo> slots = new LinkedList<SlotInfo>();
                DisplayInfo displayInfo = new DisplayInfo();
                for (int i = 0; i < lockedSlots.size(); ++i) {
                    SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(String.valueOf(lockedSlots.get(i)));
                    if (slotInfo == null || !slotInfo.getScreenId().equalsIgnoreCase(strScreenID)) continue;
                    slots.add(slotInfo);
                }
                if (slots.size() <= 0) continue;
                displayInfo.getLockedSlots().addAll(slots);
                displayInfo.setDisPlayID(strScreenID);
                displayInfo.setEmgerceny(false);
                String displayMessage = this.getSlotLockedDisplayMessage(slots);
                displayInfo.setDisPlayMessage(displayMessage);
                ICommand command = CommandCreator.getInstance().createCommand("WebColorLightCmd", displayInfo);
                boolean bl = WebCommandExecutor.getInstance().executeCmd(command);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.handleSlotLockStatus]  error: " + ex);
        }
    }

    public String getSlotStaticDisplayMessage(List<SlotInfo> slots) {
        String strInfos = "";
        JSONObject ProgramsObj = new JSONObject(this.screenTemplete);
        try {
            JSONObject ProgObj = ProgramsObj.getJSONObject("Programs");
            JSONObject Prog = ProgObj.getJSONObject("Program");
            JSONArray page = Prog.getJSONArray("Pages");
            JSONObject pageFirst = page.getJSONObject(0);
            JSONArray regions = pageFirst.getJSONArray("Regions");
            JSONObject regionFirst = regions.getJSONObject(0);
            JSONArray items = regionFirst.getJSONArray("Items");
            JSONObject itemFirst = items.getJSONObject(0);
            for (int i = 0; i < slots.size(); ++i) {
                SlotInfo slot = slots.get(i);
                String strSlotID = slot.getSlotId();
                Integer strSlotIntID = Integer.parseInt(strSlotID);
                String slotId = "";
                slotId = strSlotIntID < 10 ? "00" + strSlotID : (strSlotIntID < 100 ? "0" + strSlotIntID : strSlotID);
                int lastHourMailCount = slot.getLastHourPacketOff();
                strInfos = strInfos + "\u683c\u53e3:" + slotId + " \u5378\u8f7d\u91cf:" + lastHourMailCount + "\r\n";
            }
            itemFirst.put("IsScroll", "1");
            itemFirst.put("Text", strInfos);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.getSlotStaticDisplayMessage]  error: " + ex);
        }
        return ProgramsObj.toString();
    }

    public String getSlotLockedDisplayMessage(List<SlotInfo> slots) {
        String strInfos = "";
        JSONObject ProgramsObj = new JSONObject(this.screenTemplete);
        try {
            JSONObject ProgObj = ProgramsObj.getJSONObject("Programs");
            JSONObject Prog = ProgObj.getJSONObject("Program");
            JSONArray page = Prog.getJSONArray("Pages");
            JSONObject pageFirst = page.getJSONObject(0);
            JSONArray regions = pageFirst.getJSONArray("Regions");
            JSONObject regionFirst = regions.getJSONObject(0);
            JSONArray items = regionFirst.getJSONArray("Items");
            JSONObject itemFirst = items.getJSONObject(0);
            for (int i = 0; i < slots.size(); ++i) {
                SlotInfo slot = slots.get(i);
                String strSlotID = slot.getSlotId();
                Timestamp currentTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
                String lockTime = this.getTimeDifference(currentTime, slot.getLockTimeStamp());
                Integer strSlotIntID = Integer.parseInt(strSlotID);
                String slotId = "";
                slotId = strSlotIntID < 10 ? "00" + strSlotID : (strSlotIntID < 100 ? "0" + strSlotIntID : strSlotID);
                strInfos = strInfos + "\u683c\u53e3:" + slotId + " \u9501\u683c\u65f6\u957f:" + lockTime + "\r\n";
            }
            itemFirst.put("IsScroll", "1");
            itemFirst.put("Text", strInfos);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.getSlotLockedDisplayMessage]  error: " + ex);
        }
        return ProgramsObj.toString();
    }

    public String getEmergencyDisplayMessage(Map<String, Integer> stopIds) {
        String strInfos = "";
        String strInfos1 = "\u6025\u505c\u6309\u4e0b: ";
        String strInfos2 = "\u62d4\u51fa\u672a\u590d\u4f4d: ";
        int count1 = 0;
        int count2 = 0;
        for (String key : stopIds.keySet()) {
            if (stopIds.get(key) == 1) {
                strInfos1 = strInfos1 + key + ",";
                ++count1;
                continue;
            }
            strInfos2 = strInfos2 + key + ",";
            ++count2;
        }
        strInfos1 = strInfos1.substring(0, strInfos1.length() - 1);
        strInfos2 = strInfos2.substring(0, strInfos2.length() - 1);
        if (count1 != 0) {
            strInfos = strInfos + strInfos1;
            if (count2 != 0) {
                strInfos = strInfos + "\n" + strInfos2;
            }
        } else {
            strInfos = strInfos + strInfos2;
        }
        JSONObject ProgramsObj = new JSONObject(this.stopTemplate);
        try {
            JSONObject ProgObj = ProgramsObj.getJSONObject("Programs");
            JSONObject Prog = ProgObj.getJSONObject("Program");
            JSONArray page = Prog.getJSONArray("Pages");
            JSONObject pageFirst = page.getJSONObject(0);
            JSONArray regions = pageFirst.getJSONArray("Regions");
            JSONObject regionFirst = regions.getJSONObject(0);
            JSONArray items = regionFirst.getJSONArray("Items");
            JSONObject itemFirst = items.getJSONObject(0);
            itemFirst.put("Text", strInfos);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.getSlotDisplayMessage]  error: " + ex);
        }
        return ProgramsObj.toString();
    }

    public String getTimeDifference(Timestamp formatTime1, Timestamp formatTime2) {
        long t1 = formatTime1.getTime();
        long t2 = formatTime2.getTime();
        int hours = (int)((t1 - t2) / 3600000L);
        int minutes = (int)(((t1 - t2) / 1000L - (long)(hours * 3600)) / 60L);
        int second = (int)((t1 - t2) / 1000L - (long)(hours * 3600) - (long)(minutes * 60));
        return "" + this.addFormatTime(String.valueOf(hours)) + ":" + this.addFormatTime(String.valueOf(minutes)) + ":" + this.addFormatTime(String.valueOf(second)) + "";
    }

    public String addFormatTime(String strV) {
        String strRes = strV;
        if (strV.length() == 1) {
            strRes = "0" + strV;
        }
        return strRes;
    }

    public void emergencyDisplayMessage(JSONObject contentObj) {
        try {
            for (Map.Entry<String, ScreenInfo> entry : this.ScreenInfoMap.entrySet()) {
                String strScreenID = entry.getKey();
                LinkedList slotList = new LinkedList();
                DisplayInfo displayInfo = new DisplayInfo();
                displayInfo.getLockedSlots().addAll(slotList);
                displayInfo.setDisPlayID(strScreenID);
                displayInfo.setEmgerceny(false);
                String data = contentObj.getString("Data");
                String[] datas = data.split(",");
                HashMap<String, Integer> stopSites = new HashMap<String, Integer>();
                Map<String, Integer> existStopSites = this.stopIds;
                for (int i = 0; i < datas.length; ++i) {
                    Integer id = Integer.parseInt(datas[i]);
                    if (id == 0) continue;
                    if (i == 0) {
                        stopSites.put("\u9762\u677f", id);
                        continue;
                    }
                    stopSites.put("" + i, id);
                }
                int newlen = stopSites.size();
                if (newlen <= 0) {
                    existStopSites.clear();
                    ScreenInfoManager.getInstance().sortingScheme("TEXT");
                }
                int oldLen = existStopSites.size();
                int sum = 0;
                if (oldLen > 0 && oldLen == newlen) {
                    for (String key : stopSites.keySet()) {
                        if (existStopSites.get(key) != stopSites.get(key)) continue;
                        ++sum;
                    }
                }
                if (sum == newlen) continue;
                ScreenInfoManager.getInstance().setStopIds(stopSites);
                String strInfos = "";
                String strInfos1 = "\u6025\u505c\u6309\u4e0b: ";
                String strInfos2 = "\u62d4\u51fa\u672a\u590d\u4f4d: ";
                int count1 = 0;
                int count2 = 0;
                for (String key : stopSites.keySet()) {
                    if ((Integer)stopSites.get(key) == 1) {
                        strInfos1 = strInfos1 + key + ",";
                        ++count1;
                        continue;
                    }
                    strInfos2 = strInfos2 + key + ",";
                    ++count2;
                }
                strInfos1 = strInfos1.substring(0, strInfos1.length() - 1);
                strInfos2 = strInfos2.substring(0, strInfos2.length() - 1);
                if (count1 != 0) {
                    strInfos = strInfos + strInfos1;
                    if (count2 != 0) {
                        strInfos = strInfos + "\n" + strInfos2;
                    }
                } else {
                    strInfos = strInfos + strInfos2;
                }
                JSONObject ProgramsObj = new JSONObject(this.stopTemplate);
                try {
                    JSONObject ProgObj = ProgramsObj.getJSONObject("Programs");
                    JSONObject Prog = ProgObj.getJSONObject("Program");
                    JSONArray page = Prog.getJSONArray("Pages");
                    JSONObject pageFirst = page.getJSONObject(0);
                    JSONArray regions = pageFirst.getJSONArray("Regions");
                    JSONObject regionFirst = regions.getJSONObject(0);
                    JSONArray items = regionFirst.getJSONArray("Items");
                    JSONObject itemFirst = items.getJSONObject(0);
                    itemFirst.put("Text", strInfos);
                }
                catch (Exception ex) {
                    LogUtil.LogError(logger, "[ScreenManager.getSlotDisplayMessage]  error: " + ex);
                }
                String displayMessage = ProgramsObj.toString();
                displayInfo.setDisPlayMessage(displayMessage);
                ICommand command = CommandCreator.getInstance().createCommand("WebColorLightCmd", displayInfo);
                boolean bl = WebCommandExecutor.getInstance().executeCmd(command);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.getSlotDisplayMessage]  error: " + ex);
        }
    }

    private List<SlotInfo> getListSlotInfo() {
        LinkedList<SlotInfo> slots = new LinkedList<SlotInfo>();
        LinkedList<Integer> lockedSlots = new LinkedList<Integer>();
        ICommand command = CommandCreator.getInstance().createCommand("FetchSlotInfoCmd", slots);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue()) {
            for (SlotInfo slotTmp : slots) {
                PrinterInfo printerInfo;
                String slotId = slotTmp.getSlotId();
                String printerMasterId = slotTmp.getMasterPrinterId();
                String printerSlaveId = slotTmp.getSlavePrinterId();
                int slotDistrict = slotTmp.getSlotDistrict();
                SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
                if (slotInfo == null) continue;
                if (slotInfo.getLockStatus() > 0) {
                    lockedSlots.add(Integer.parseInt(slotId));
                }
                if ((printerInfo = PrinterInfoManager.getInstance().getPrinterInfo(printerMasterId)) != null) {
                    slotInfo.setMasterPrinterId(printerInfo.getPrinterId());
                    slotInfo.setMasterPrinterIp(printerInfo.getPrinterIp());
                }
                if ((printerInfo = PrinterInfoManager.getInstance().getPrinterInfo(printerSlaveId)) != null) {
                    slotInfo.setSlavePrinterId(printerInfo.getPrinterId());
                    slotInfo.setSlavePrinterIp(printerInfo.getPrinterIp());
                }
                slotInfo.setSlotDistrict(slotDistrict);
            }
        }
        if (lockedSlots.size() > 0) {
            ScreenInfoManager.getInstance().handleSlotLockStatus(lockedSlots);
        }
        return slots;
    }

    public String getScreenTemplete() {
        return this.screenTemplete;
    }

    public void setScreenTemplete(String screenTemplete) {
        this.screenTemplete = screenTemplete;
    }

    public String getStopTemplate() {
        return this.stopTemplate;
    }

    public void setStopTemplate(String stopTemplate) {
        this.stopTemplate = stopTemplate;
    }

    public void chuteSlotStatus(JSONObject contentObj) {
        try {
            if (this.stopIds != null && this.stopIds.size() > 0) {
                return;
            }
            int second = 0;
            Timestamp lockedTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            if (this.lastTime != null) {
                long priorTime = this.lastTime.getTime();
                long newTime = lockedTime.getTime();
                second = (int)(newTime - priorTime) / 1000;
            }
            String data = contentObj.getString("Data");
            String[] datas = data.split(",");
            ArrayList<Integer> lockedSlots = new ArrayList<Integer>();
            HashMap<Integer, Integer> chuteStatus = new HashMap<Integer, Integer>();
            boolean repetition = false;
            for (int i = 0; i < datas.length; ++i) {
                chuteStatus.put(i + 1, Integer.parseInt(datas[i]));
            }
            for (Integer n : chuteStatus.keySet()) {
                if ((Integer)chuteStatus.get(n) == 0) continue;
                lockedSlots.add(n);
            }
            if (lockedSlots.size() == 0) {
                ScreenInfoManager.getInstance().sortingScheme("TEXT");
            } else {
                for (Integer n : priorLockedList) {
                    boolean exist = false;
                    for (Integer newId : lockedSlots) {
                        if (n != newId) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    priorLockedSlots.remove(n);
                }
                if (second < 10) {
                    if (priorLockedList.size() == lockedSlots.size()) {
                        for (Integer n : lockedSlots) {
                            if (!priorLockedSlots.containsKey(String.valueOf(n))) {
                                repetition = false;
                                break;
                            }
                            repetition = true;
                        }
                    }
                    if (repetition) {
                        return;
                    }
                }
                priorLockedList.clear();
                for (Integer n : lockedSlots) {
                    priorLockedList.add(n);
                }
                for (Map.Entry entry : this.ScreenInfoMap.entrySet()) {
                    String strScreenID = (String)entry.getKey();
                    LinkedList<SlotInfo> slots = new LinkedList<SlotInfo>();
                    DisplayInfo displayInfo = new DisplayInfo();
                    for (Integer i : lockedSlots) {
                        SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(String.valueOf(i));
                        if (slotInfo == null) {
                            return;
                        }
                        if (!slotInfo.getScreenId().equalsIgnoreCase(strScreenID)) continue;
                        if (priorLockedSlots.get(String.valueOf(i)) != null) {
                            Timestamp timestamp = priorLockedSlots.get(String.valueOf(i));
                        } else {
                            slotInfo.setLockTimeStamp(lockedTime);
                            priorLockedSlots.put(String.valueOf(i), lockedTime);
                        }
                        slots.add(slotInfo);
                    }
                    if (slots.size() <= 0) continue;
                    this.lastTime = lockedTime;
                    displayInfo.getLockedSlots().addAll(slots);
                    displayInfo.setDisPlayID(strScreenID);
                    displayInfo.setEmgerceny(false);
                    String displayMessage = this.getSlotLockedDisplayMessage(slots);
                    displayInfo.setDisPlayMessage(displayMessage);
                    ICommand command = CommandCreator.getInstance().createCommand("WebColorLightCmd", displayInfo);
                    boolean bl = WebCommandExecutor.getInstance().executeCmd(command);
                }
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.getSlotStaticDisplayMessage]  error: " + ex);
        }
    }

    public void sortingScheme(String data) {
        try {
            if (this.stopIds != null && this.stopIds.size() > 0) {
                return;
            }
            for (Map.Entry<String, ScreenInfo> entry : this.ScreenInfoMap.entrySet()) {
                String strScreenID = entry.getKey();
                LinkedList slots = new LinkedList();
                DisplayInfo displayInfo = new DisplayInfo();
                displayInfo.getLockedSlots().addAll(slots);
                displayInfo.setDisPlayID(strScreenID);
                displayInfo.setEmgerceny(false);
                String displayMessage = this.getSortingSchemeMessage(data);
                displayInfo.setDisPlayMessage(displayMessage);
                ICommand command = CommandCreator.getInstance().createCommand("WebColorLightCmd", displayInfo);
                boolean bl = WebCommandExecutor.getInstance().executeCmd(command);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.getSlotStaticDisplayMessage]  error: " + ex);
        }
    }

    public String getSortingSchemeMessage(String Scheme2) {
        String strInfos = "";
        JSONObject ProgramsObj = new JSONObject(this.screenTemplete);
        try {
            JSONObject ProgObj = ProgramsObj.getJSONObject("Programs");
            JSONObject Prog = ProgObj.getJSONObject("Program");
            JSONArray page = Prog.getJSONArray("Pages");
            JSONObject pageFirst = page.getJSONObject(0);
            JSONArray regions = pageFirst.getJSONArray("Regions");
            JSONObject regionFirst = regions.getJSONObject(0);
            JSONArray items = regionFirst.getJSONArray("Items");
            JSONObject itemFirst = items.getJSONObject(0);
            strInfos = strInfos + "\u5f53\u524d\u5206\u62e3\u65b9\u6848:" + Scheme2;
            itemFirst.put("Text", strInfos);
            itemFirst.put("VerticalAlign", 1);
            itemFirst.put("CenteralAlign", 1);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ScreenManager.getSlotLockedDisplayMessage]  error: " + ex);
        }
        return ProgramsObj.toString();
    }

    private static class ScreenManagerHolder {
        private static final ScreenInfoManager INSTANCE = new ScreenInfoManager();

        private ScreenManagerHolder() {
        }
    }
}

