/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WebSlotLockStatusCmd
implements ICommand {
    public static final String NAME = "WebSlotLockStatusCmd";
    private static final Logger logger = Logger.getLogger(WebSlotLockStatusCmd.class);
    private final List<Integer> lockedSlots;

    public WebSlotLockStatusCmd(List<Integer> lockedSlots) {
        this.lockedSlots = lockedSlots;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/AutoSort/ModifyChuteStatus";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        if (!SorterParams.getInstance().isNeedBoxInfo()) {
            serverHost = SorterParams.getInstance().getDebugServerHost();
            serverPort = SorterParams.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createSlotLockedStatusContent(this.lockedSlots);
        LogUtil.LogDebug(logger, "ModifyChuteStatus content:" + content);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            JSONObject responseObj;
            int status;
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            LogUtil.LogDebug(logger, "ModifyChuteStatus response:" + content);
            if (content.contains("400 Bad Request")) {
                LogUtil.LogError(logger, "Catch 400 error:response msg is" + content);
            }
            ret = (status = (responseObj = new JSONObject(content)).getInt("Code")) == 200 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "Catch IO Exception when ModifyChuteStatus , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }
}

