/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.task.RSAEncrypt;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebLineCodeCmd
implements ICommand {
    public static final String NAME = "WebLineCodeCmd";
    protected static final Logger logger = Logger.getLogger(WebLineCodeCmd.class);
    private final String sorterParams;

    public WebLineCodeCmd(String sorterParams) {
        this.sorterParams = sorterParams;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/tads-sort-itf/expressSort/lineStarOrStop";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        if (!SorterParams.getInstance().isNeedDataUpload()) {
            serverHost = SorterParams.getInstance().getDebugServerHost();
            serverPort = SorterParams.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createGetLineCode();
        LogUtil.LogError(logger, "req lince code:" + content);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.addHeader("Token", RSAEncrypt.getToken());
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            if (content.contains("Token\u8ba4\u8bc1\u5931\u8d25")) {
                LogUtil.LogError(logger, "Token\u8ba4\u8bc1\u5931\u8d25");
                return false;
            }
            LogUtil.LogError(logger, "res lince code:" + content);
            JSONObject responseObj = new JSONObject(content);
            int status = Integer.parseInt(responseObj.getString("status"));
            if (status == 1) {
                JSONArray lineCodeArr = responseObj.getJSONArray("data");
                int length = lineCodeArr.length();
                if (length <= 0) {
                    return null;
                }
                ArrayList<String> lineCode = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    lineCode.add(lineCodeArr.getString(i));
                }
                SorterParams.getInstance().setLineCodeList(lineCode);
                SorterParams.getInstance().setLineCode((String)lineCode.get(0));
                ret = true;
            }
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "Catch IO Exception when request lineCode , Response Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        return ret;
    }
}

