/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.SlotInfo;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class WebBoxInfoCmd
implements ICommand {
    public static final String NAME = "WebBoxInfoCmd";
    private static final Logger logger = Logger.getLogger(WebBoxInfoCmd.class);
    private final SlotInfo slotInfo;

    public WebBoxInfoCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        this.parseBoxInfos();
        return true;
    }

    private void parseBoxInfos() {
        String slotId = this.slotInfo.getSlotId();
        BoxInfo boxInfo = this.slotInfo.getBoxInfo();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.sss");
        String strCurTime = sdf.format(ts);
        String response = strCurTime.replaceAll("[[\\s-:punct:]]", "");
        response = response.replace(".", "");
        response = response + "-" + slotId;
        boxInfo.setBoxCode(response);
        boxInfo.setBoxType("0");
        boxInfo.setSlotId(slotId);
    }
}

