/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.TrashSlotInfo;

public class RecordTrashSlotsInfoCmd
implements ICommand {
    public static final String NAME = "RecordTrashSlotsInfoCmd";
    private final TrashSlotInfo trashSlotInfo;
    private final String sql = "insert into tt_trash_slots(slotId) values (?) ";

    public RecordTrashSlotsInfoCmd(TrashSlotInfo trashSlotInfo) {
        this.trashSlotInfo = trashSlotInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        if (this.trashSlotInfo == null || this.trashSlotInfo.getTrashSlots().size() == 0) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.clearParameters();
            dbOperator.prepareStatement(this.sql);
            dbOperator.setAutoCommit(false);
            for (int i = 0; i < this.trashSlotInfo.getTrashSlots().size(); ++i) {
                dbOperator.setInt(1, this.trashSlotInfo.getTrashSlots().get(i));
                dbOperator.addBatch();
            }
            int[] rs = dbOperator.executeBatch();
            if (rs == null || rs.length <= 0) {
                return ret;
            }
            dbOperator.commit();
            dbOperator.setAutoCommit(true);
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

