/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.PacketOnInfo;
import java.sql.Timestamp;

public class RecordPacketOnCmd
implements ICommand {
    public static final String NAME = "RecordPacketOnCmd";
    private final PacketOnInfo packetOnInfo;
    private final String sql = "insert into tt_packet_on_info(barcode,platId,carId,plcId,platMode,scannedMode,scannedPlatType,workerNo,packetOnTime) values(?,?,?,?,?,?,?,?,?);";

    public RecordPacketOnCmd(PacketOnInfo packetOnInfo) {
        this.packetOnInfo = packetOnInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String barcode = this.packetOnInfo.getBarcode();
            if (barcode == null || barcode.equals("")) {
                barcode = "none";
            }
            dbOperator.setString(1, barcode);
            String platId = String.valueOf(this.packetOnInfo.getPlatId());
            if (platId == null || platId.equals("")) {
                platId = "none";
            }
            dbOperator.setString(2, platId);
            String carId = this.packetOnInfo.getCarId();
            if (carId == null || carId.equals("")) {
                carId = "0";
            }
            dbOperator.setString(3, carId);
            String plcId = this.packetOnInfo.getPlcId();
            if (plcId == null || plcId.equals("")) {
                plcId = "none";
            }
            dbOperator.setString(4, plcId);
            String platMode = this.packetOnInfo.getPlatMode();
            if (platMode == null || platMode.equals("")) {
                platMode = "0";
            }
            dbOperator.setString(5, platMode);
            String scannedMode = this.packetOnInfo.getScannedMode();
            if (scannedMode == null || scannedMode.equals("")) {
                scannedMode = "none";
            }
            dbOperator.setString(6, scannedMode);
            String scannedPlatType = this.packetOnInfo.getScannedPlatType();
            if (scannedPlatType == null || scannedPlatType.equals("")) {
                scannedPlatType = "none";
            }
            dbOperator.setString(7, scannedPlatType);
            String workerNo = "none-worker";
            dbOperator.setString(8, workerNo);
            Timestamp packetOnTime = this.packetOnInfo.getPacketOnTime();
            if (packetOnTime == null) {
                packetOnTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String packetOnTimeContent = packetOnTime.toString();
            dbOperator.setString(9, packetOnTimeContent);
            int res = dbOperator.executeUpdate();
            ret = res > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

