/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SortInfo;
import java.sql.Timestamp;

public class RecordPacketOffCmd
implements ICommand {
    public static final String NAME = "RecordPacketOffCmd";
    private final SortInfo sortInfo;
    private final String sql = "insert into tt_packet_off_info(barcode,carId,platId,plcId,serverSlots,droppedSlot,siteCode,siteCodeList,uuid,boxCode,turnNumber,obrNo,errorCodeSVR,errorCodePLC,scannedTime,packetOffTime,uploadFlag,uploadNum,slotDistrict,scannedMode,scannedPlatType,layer,sortSource,errorDesc,oriBarcode) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

    public RecordPacketOffCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String barcode = this.sortInfo.getBarcode();
            if (barcode == null || barcode.equals("")) {
                barcode = "none";
            }
            dbOperator.setString(1, barcode);
            String carId = this.sortInfo.getCarId();
            if (carId == null || carId.equals("")) {
                carId = "0";
            }
            dbOperator.setString(2, carId);
            String platId = String.valueOf(this.sortInfo.getPlatId());
            if (platId == null || platId.equals("")) {
                platId = "none";
            }
            dbOperator.setString(3, platId);
            String plcId = this.sortInfo.getPlcId();
            if (plcId == null || plcId.equals("")) {
                plcId = "none";
            }
            dbOperator.setString(4, plcId);
            String serverSlots = this.createServerSlots();
            dbOperator.setString(5, serverSlots);
            int droppedSlot = this.sortInfo.getDroppedSlotId();
            dbOperator.setInt(6, droppedSlot);
            String siteCode = this.sortInfo.getSiteCode();
            if (siteCode == null || siteCode.equals("")) {
                siteCode = "none";
            }
            dbOperator.setString(7, siteCode);
            String siteCodes = siteCode;
            dbOperator.setString(8, siteCodes);
            String sortingId = this.sortInfo.getUuid();
            dbOperator.setString(9, sortingId);
            String boxCode = this.sortInfo.getBoxCode();
            if (boxCode == null || boxCode.equals("")) {
                boxCode = "none";
            }
            dbOperator.setString(10, boxCode);
            int turnNumber = Integer.parseInt(this.sortInfo.getTurnNumber());
            dbOperator.setInt(11, turnNumber);
            int obrNo = this.sortInfo.getObr();
            dbOperator.setInt(12, obrNo);
            int errorCodeSVR = this.sortInfo.getErrorCodeSVR();
            int errorOriSvr = this.sortInfo.getOriginalErrorCode();
            if (errorOriSvr > 0) {
                errorCodeSVR = errorOriSvr;
            }
            dbOperator.setInt(13, errorCodeSVR);
            int errorCodePLC = this.sortInfo.getErrorCodePLC();
            dbOperator.setInt(14, errorCodePLC);
            Timestamp scannedTime = this.sortInfo.getTimestampScanned();
            if (scannedTime == null) {
                scannedTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String scannedTimeContent = scannedTime.toString();
            dbOperator.setString(15, scannedTimeContent);
            Timestamp packetOffTime = this.sortInfo.getTimestampPacketOff();
            if (packetOffTime == null) {
                packetOffTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String packetOffTimeContent = packetOffTime.toString();
            dbOperator.setString(16, packetOffTimeContent);
            int uploadFlag = this.sortInfo.getUploadFlag();
            dbOperator.setInt(17, uploadFlag);
            int uploadNum = this.sortInfo.getUploadNum();
            dbOperator.setInt(18, uploadNum);
            int slotDistrict = this.sortInfo.getSlotDistrict();
            dbOperator.setInt(19, slotDistrict);
            String scannedMode = this.sortInfo.getScannedMode();
            if (scannedMode == null || scannedMode.equals("")) {
                scannedMode = "none";
            }
            dbOperator.setString(20, scannedMode);
            String scannedPlatType = this.sortInfo.getScannedPlatType();
            if (scannedPlatType == null || scannedPlatType.equals("")) {
                scannedPlatType = "none";
            }
            dbOperator.setString(21, scannedPlatType);
            String layer = "1";
            dbOperator.setString(22, layer);
            String sourtSource = this.sortInfo.getSortSource();
            if (sourtSource == null || sourtSource.equals("")) {
                sourtSource = "1";
            }
            dbOperator.setInt(23, Integer.parseInt(sourtSource));
            String strErrorDesc = SortProtocolCreator.getInstance().getDepponErrorDesc(errorCodeSVR);
            if (strErrorDesc == null || strErrorDesc.equals("")) {
                strErrorDesc = "\u672a\u77e5";
            }
            dbOperator.setString(24, strErrorDesc);
            String oriBarcode = "";
            for (String obarcode : this.sortInfo.getBarcodeList()) {
                oriBarcode = oriBarcode + obarcode + ",";
            }
            if ((oriBarcode = oriBarcode.substring(0, oriBarcode.length() - 1)) == null || oriBarcode.equals("")) {
                oriBarcode = "1";
            }
            dbOperator.setString(25, oriBarcode);
            int res = dbOperator.executeUpdate();
            if (res > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private String createServerSlots() {
        String serverSlots = "none";
        try {
            StringBuilder slotsContent = new StringBuilder();
            int slotNum = this.sortInfo.getSlotsList().size();
            for (int i = 0; i < slotNum; ++i) {
                if (i != slotNum - 1) {
                    slotsContent.append(String.valueOf(this.sortInfo.getSlotsList().get(i)));
                    slotsContent.append(",");
                    continue;
                }
                slotsContent.append(String.valueOf(this.sortInfo.getSlotsList().get(i)));
            }
            serverSlots = slotsContent.toString();
            if (serverSlots.equals("")) {
                serverSlots = "none";
            }
        }
        catch (Exception e) {
            serverSlots = "ex-server-slots";
        }
        return serverSlots;
    }

    private String createSiteCodes() {
        String siteCodes = "none";
        try {
            StringBuilder siteCodesContent = new StringBuilder();
            int siteCodesNum = this.sortInfo.getSiteCodeList().size();
            for (int i = 0; i < siteCodesNum; ++i) {
                if (i != siteCodesNum - 1) {
                    siteCodesContent.append(String.valueOf(this.sortInfo.getSiteCodeList().get(i)));
                    siteCodesContent.append(",");
                    continue;
                }
                siteCodesContent.append(String.valueOf(this.sortInfo.getSiteCodeList().get(i)));
            }
            String siteCodesToCheck = siteCodesContent.toString();
            if (siteCodesToCheck == null || siteCodesToCheck.equals("")) {
                siteCodesToCheck = "none";
            } else {
                siteCodes = siteCodesToCheck.length() >= 30 ? "long-site-codes" : siteCodesToCheck;
            }
        }
        catch (Exception e) {
            siteCodes = "ex-none";
        }
        return siteCodes;
    }

    private String createSortingId() {
        String sortingId = "none";
        try {
            sortingId = this.sortInfo.getSortingId();
            if (sortingId == null || sortingId.equals("")) {
                sortingId = "none";
            }
            if (sortingId.length() > 16) {
                sortingId = sortingId.substring(0, 16);
            }
        }
        catch (Exception e) {
            sortingId = "ex-sorting-id";
        }
        return sortingId;
    }
}

