/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.BoxInfo;

public class RecordBoxFailedInfoCmd
implements ICommand {
    public static final String NAME = "RecordBoxFailedInfoCmd";
    private final BoxInfo boxInfo;
    private final String sql = "insert into tt_slot_pack_fail(linceCode, slotId,chuteCode, mailCount, recordTime) values (?,?,?,?,?)";

    public RecordBoxFailedInfoCmd(BoxInfo boxinfo) {
        this.boxInfo = boxinfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        if (this.boxInfo == null) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.clearParameters();
            dbOperator.prepareStatement(this.sql);
            dbOperator.setAutoCommit(false);
            dbOperator.setString(1, this.boxInfo.getLineCode());
            dbOperator.setString(2, this.boxInfo.getSlotId());
            dbOperator.setString(3, this.boxInfo.getSlotId());
            dbOperator.setInt(4, this.boxInfo.getMailCount());
            dbOperator.setString(5, this.boxInfo.getOperateTime());
            int[] rs = dbOperator.executeBatch();
            if (rs == null || rs.length <= 0) {
                return ret;
            }
            dbOperator.commit();
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

