/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.PrinterInfoManager;
import com.simba.server.components.ScreenInfoManager;
import com.simba.server.components.data.PrinterInfo;
import com.simba.server.components.data.ScreenInfo;
import com.simba.server.components.data.SlotInfo;
import java.sql.ResultSet;
import java.util.List;

public class FetchSlotInfoCmd
implements ICommand {
    public static final String NAME = "FetchSlotInfoCmd";
    private final List<SlotInfo> slotInfos;
    private final String sql = "select * from tt_slot_config;";

    public FetchSlotInfoCmd(List<SlotInfo> slotInfos) {
        this.slotInfos = slotInfos;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        this.slotInfos.clear();
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                SlotInfo slotInfo = new SlotInfo();
                String slotId = rs.getString("slotId");
                slotInfo.setSlotId(slotId);
                String chuteCode = rs.getString("chuteCode");
                slotInfo.setChuteCode(chuteCode);
                String printerMasterId = rs.getString("masterPrinterId");
                PrinterInfo printerInfo = PrinterInfoManager.getInstance().getPrinterInfo(printerMasterId);
                if (printerInfo != null) {
                    slotInfo.setMasterPrinterId(printerInfo.getPrinterId());
                    slotInfo.setMasterPrinterIp(printerInfo.getPrinterIp());
                }
                String printerSlaveId = rs.getString("slavePrinterId");
                printerInfo = PrinterInfoManager.getInstance().getPrinterInfo(printerSlaveId);
                if (printerInfo != null) {
                    slotInfo.setSlavePrinterId(printerInfo.getPrinterId());
                    slotInfo.setSlavePrinterIp(printerInfo.getPrinterIp());
                }
                String screenId = rs.getString("screenId");
                ScreenInfo screenInfo = ScreenInfoManager.getInstance().getScreenInfo(screenId);
                if (screenInfo != null) {
                    slotInfo.setScreenId(screenInfo.getScreenId());
                    slotInfo.setScreenIp(screenInfo.getScreenIp());
                }
                int slotDistrict = rs.getInt("slotDistrict");
                slotInfo.setSlotDistrict(slotDistrict);
                this.slotInfos.add(slotInfo);
                ret = true;
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

