/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.PrinterInfo;
import java.sql.ResultSet;
import java.util.List;

public class FetchPrinterInfoCmd
implements ICommand {
    public static final String NAME = "FetchPrinterInfoCmd";
    private final List<PrinterInfo> printerInfos;
    private final String sql = "select * from tt_printer_config;";

    public FetchPrinterInfoCmd(List<PrinterInfo> printerInfos) {
        this.printerInfos = printerInfos;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                PrinterInfo printerInfo = new PrinterInfo();
                String printerId = rs.getString("printerId");
                printerInfo.setPrinterId(printerId);
                String printerIp = rs.getString("printerIp");
                printerInfo.setPrinterIp(printerIp);
                int printerPort = rs.getInt("printerPort");
                printerInfo.setPrinterPort(printerPort);
                this.printerInfos.add(printerInfo);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

