/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server;

import com.simba.GlobalParam;
import com.simba.common.DefaultServerInfo;
import com.simba.common.log.LogHelper;
import com.simba.server.ServerManager;
import com.simba.server.components.SorterParams;
import java.io.File;
import org.jdom2.Document;
import org.jdom2.Element;

public class ServerParam {
    public static String ACCESS_LOG = "access.log";
    public static int CAR_NUMBER = 500;
    public static String CONFIG_XML_FILE = "etc" + GlobalParam.PATH_SEP + "simba-server-config.xml";
    public static int DECODER_THREAD_POOL_SIZE = 10;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static String ERROR_LOG = "error.log";
    public static int EVENT_THREAD_POOL_SIZE = 5;
    public static final String FALSE_STRING = "false";
    public static int IO_THREAD_POOL_SIZE = 5;
    public static boolean IS_WINDOWS_SERVER = false;
    public static String LOG_PATH = "logs";
    public static String NEED_DEBUG = "false";
    public static final String SERVER_VERSION = "1.0";
    public static final String TRUE_STRING = "true";
    public static String VERBOSE_LOG = "verbose.log";
    private static final int DEFAULT_TURN_NUMBER = 3;
    private static DefaultServerInfo serverInfo;
    public static String SCREEN_JSON_FILE;
    public static String SCREEN_JSON_Template;

    public static DefaultServerInfo getServerInfo() {
        return serverInfo;
    }

    public static void initGlobalConfiguration() {
        try {
            String os = System.getProperty("os.name");
            IS_WINDOWS_SERVER = os.substring(0, 3).equalsIgnoreCase("win");
            serverInfo = new DefaultServerInfo();
            Document rootMessage = ServerManager.getInstance().getXmlDocFromFile(new File(CONFIG_XML_FILE));
            Element rootElement = rootMessage.getRootElement();
            ServerParam.initConnectionSectionConfiguration(rootElement);
            ServerParam.initGlobalSectionConfiguration(rootElement);
        }
        catch (Exception ex) {
            System.out.println("Init global server configuration " + CONFIG_XML_FILE + " error: " + ex);
            System.out.println("Server Started failed");
            System.exit(5000);
        }
    }

    public static void initRootLogger(String configFile) {
        File fp = new File(LOG_PATH);
        if (fp.exists()) {
            boolean canWrite = fp.canWrite();
            if (!canWrite) {
                System.out.println("Fatal Error: Log path: " + LOG_PATH + " can't write");
                System.exit(5000);
            }
        } else if (!fp.mkdir()) {
            System.out.println("Fatal Error: Data path: " + LOG_PATH + " can't create");
            System.exit(5000);
        }
        String accessLogPath = LOG_PATH + GlobalParam.PATH_SEP + ACCESS_LOG;
        String errorLogPath = LOG_PATH + GlobalParam.PATH_SEP + ERROR_LOG;
        String verboseLogPath = LOG_PATH + GlobalParam.PATH_SEP + VERBOSE_LOG;
        try {
            LogHelper.configure(configFile, verboseLogPath, accessLogPath, errorLogPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printStartedInfo() {
        System.out.println("Simba Server has been Started!");
        System.out.println("*****************************************");
        System.out.println("*                                       *");
        System.out.println("*                                       *");
        System.out.println("* Simba-Yun-Express-Sorter-Server-1.3   *");
        System.out.println("* update 2020-06-10 15:13               *");
        System.out.println("*                                       *");
        System.out.println("*****************************************");
        System.out.println(" ");
    }

    public static String replaceSlash(String path) {
        String result = path;
        result = GlobalParam.PATH_SEP.equals("\\") ? result.replaceAll("/", "\\\\") : result.replaceAll("\\\\", "/");
        if (result.substring(result.length() - 1).equals(GlobalParam.PATH_SEP)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static void initConnectionSectionConfiguration(Element rootElement) {
        Element connElement = rootElement.getChild("Connection");
        String frameServerAddress = connElement.getChild("frame-sorter-server").getAttribute("ip").getValue();
        serverInfo.setDefaultServerAddress(frameServerAddress);
        serverInfo.setDefaultServerPort(Integer.parseInt(connElement.getChild("frame-sorter-server").getAttribute("port").getValue()));
        String jsonServerAddress = connElement.getChild("json-content-server").getAttribute("ip").getValue();
        serverInfo.setJsonServerAddress(jsonServerAddress);
        serverInfo.setJsonServerPort(Integer.parseInt(connElement.getChild("json-content-server").getAttribute("port").getValue()));
        String httpServerAddress = connElement.getChild("http-json-server").getAttribute("ip").getValue();
        serverInfo.setHttpServerAddress(httpServerAddress);
        serverInfo.setHttpServerPort(Integer.parseInt(connElement.getChild("http-json-server").getAttribute("port").getValue()));
    }

    private static void initGlobalSectionConfiguration(Element rootElement) throws Exception {
        Element globalElement = rootElement.getChild("Global");
        EVENT_THREAD_POOL_SIZE = Integer.parseInt(globalElement.getChild("event-threads").getText());
        IO_THREAD_POOL_SIZE = Integer.parseInt(globalElement.getChild("io-workers").getText());
        DECODER_THREAD_POOL_SIZE = Integer.parseInt(globalElement.getChild("decoder-workers").getText());
        CAR_NUMBER = Integer.parseInt(globalElement.getChild("car-number").getText());
        LOG_PATH = globalElement.getChild("log-path").getText();
        NEED_DEBUG = globalElement.getChild("need-debug").getText();
        String slotNumberStr = globalElement.getChild("slot-number").getText();
        int slotNumber = Integer.parseInt(slotNumberStr);
        SorterParams.getInstance().setSlotNumber(slotNumber);
        SorterParams.getInstance().setTurnNumber(3);
        String simulateMode = globalElement.getChild("simulate-mode").getText();
        if (simulateMode.equalsIgnoreCase(TRUE_STRING)) {
            SorterParams.getInstance().setSimulateMode(true);
        } else {
            SorterParams.getInstance().setSimulateMode(false);
        }
        String newThreadEachReq = globalElement.getChild("new-thread-each-request").getText();
        if (newThreadEachReq.equalsIgnoreCase(TRUE_STRING)) {
            SorterParams.getInstance().setNewThreadEachRequest(true);
        } else {
            SorterParams.getInstance().setNewThreadEachRequest(false);
        }
        String multiCodeCheck = globalElement.getChild("multi-code-check").getText();
        if (multiCodeCheck.equalsIgnoreCase(TRUE_STRING)) {
            SorterParams.getInstance().setMultiCodeCheck(true);
        } else {
            SorterParams.getInstance().setMultiCodeCheck(false);
        }
        String needSortPlan = globalElement.getChild("need-sort-plan").getText();
        if (needSortPlan.equalsIgnoreCase(TRUE_STRING)) {
            SorterParams.getInstance().setNeedSortPlan(true);
        } else {
            SorterParams.getInstance().setNeedSortPlan(false);
        }
        String needBoxInfo = globalElement.getChild("need-box-info").getText();
        if (needBoxInfo.equalsIgnoreCase(TRUE_STRING)) {
            SorterParams.getInstance().setNeedBoxInfo(true);
        } else {
            SorterParams.getInstance().setNeedBoxInfo(false);
        }
        String needDataUpload = globalElement.getChild("need-data-upload").getText();
        if (needDataUpload.equalsIgnoreCase(TRUE_STRING)) {
            SorterParams.getInstance().setNeedDataUpload(true);
        } else {
            SorterParams.getInstance().setNeedDataUpload(false);
        }
        String machineCode = globalElement.getChild("machine-code").getText();
        SorterParams.getInstance().setMachineCode(machineCode);
        String serverAddress = globalElement.getChild("server-host").getText();
        SorterParams.getInstance().setServerHost(serverAddress);
        String serverPort = globalElement.getChild("server-port").getText();
        SorterParams.getInstance().setServerPort(serverPort);
        String debugServerAddress = globalElement.getChild("debug-server-host").getText();
        SorterParams.getInstance().setDebugServerHost(debugServerAddress);
        String debugServerPort = globalElement.getChild("debug-server-port").getText();
        SorterParams.getInstance().setDebugServerPort(debugServerPort);
        String uploadNum = globalElement.getChild("upload-num").getText();
        SorterParams.getInstance().setUploadNum(Integer.parseInt(uploadNum));
        String restoreDaysPacketOff = globalElement.getChild("restore-days-packet-off").getText();
        SorterParams.getInstance().setRestoreDaysPacketOff(Integer.parseInt(restoreDaysPacketOff));
        String restoreDaysSlotPack = globalElement.getChild("restore-days-slot-pack").getText();
        SorterParams.getInstance().setRestoreDaysSlotPack(Integer.parseInt(restoreDaysSlotPack));
        String restoreDaysBoxInfo = globalElement.getChild("restore-days-box-info").getText();
        SorterParams.getInstance().setRestoreDaysBoxInfo(Integer.parseInt(restoreDaysBoxInfo));
        String deleteDataTime = globalElement.getChild("delete-data-time").getText();
        SorterParams.getInstance().setDeleteDataTime(Integer.parseInt(deleteDataTime));
        String sortPlanReqTime = globalElement.getChild("sort-plan-request-time").getText();
        SorterParams.getInstance().setSortPlanRequestTime(Integer.parseInt(sortPlanReqTime));
        String strOrgCode = globalElement.getChild("org-code").getText();
        SorterParams.getInstance().setOrgCode(strOrgCode);
        String strVersion = globalElement.getChild("version").getText();
        SorterParams.getInstance().setVersion(strVersion);
        String strCompany = globalElement.getChild("company-name").getText();
        SorterParams.getInstance().setCompany(strCompany);
        String strDevType = globalElement.getChild("dev-type").getText();
        SorterParams.getInstance().setDevType(strDevType);
        String isUserVC = globalElement.getChild("isUseVC").getText();
        SorterParams.getInstance().setIsUseVC(Integer.parseInt(isUserVC));
        String strFtpUrl = globalElement.getChild("ftpUrl").getText();
        SorterParams.getInstance().setFtpUrl(strFtpUrl);
        String strFtpUser = globalElement.getChild("ftpUser").getText();
        SorterParams.getInstance().setFtpUser(strFtpUser);
        String strFtpPwd = globalElement.getChild("ftpPwd").getText();
        SorterParams.getInstance().setFtpPwd(strFtpPwd);
    }

    static {
        SCREEN_JSON_FILE = "etc" + GlobalParam.PATH_SEP + "linespacing.json";
        SCREEN_JSON_Template = "etc" + GlobalParam.PATH_SEP + "emergencyStopTemplate.json";
    }
}

