/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.processor;

import com.simba.GlobalParam;
import com.simba.common.ChannelManager;
import com.simba.common.RequestHandler;
import com.simba.common.log.LogUtil;
import com.simba.common.processor.BaseProcessor;
import com.simba.common.utils.StringUtil;
import java.io.IOException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class PadFrameProcessor
extends BaseProcessor {
    private final ChannelManager channelManager;
    private final RequestHandler frameContentDecoder;

    public PadFrameProcessor(RequestHandler requestHandler, ChannelManager chManager) {
        this.frameContentDecoder = requestHandler;
        this.channelManager = chManager;
    }

    @Override
    public void onChannelConnected(Channel channel) throws Exception {
        this.addChannel(channel);
        this.logOnChannelConnected(channel);
        this.frameContentDecoder.onChannelConnected(channel);
    }

    @Override
    public void onChannelDisconnected(Channel channel) throws Exception {
        this.removeChannel(channel);
        this.logOnChannelDisconnected(channel);
        this.frameContentDecoder.onChannelDisconnected(channel);
    }

    @Override
    public void onChannelIdle(Channel channel, IdleStateEvent e) throws Exception {
        this.logOnChannelIdel(channel, e);
    }

    @Override
    public void onExceptionCaught(Channel channel, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            this.logOnIOExceptionCaught(channel, cause);
        } else {
            this.logOnExceptionCaught(channel, cause);
            if (!channel.isConnected()) {
                this.removeChannel(channel);
            }
        }
    }

    @Override
    public void onMessageReceived(Channel channel, Object message) throws Exception {
        byte[] contentMsg = (byte[])message;
        this.logOnMessageReceived(channel, contentMsg);
        if (this.frameContentDecoder != null) {
            this.frameContentDecoder.handleRequest(channel, message);
        }
    }

    @Override
    public void onWriteComplete(Channel channel) throws Exception {
    }

    @Override
    protected void addChannel(Channel channel) {
        this.channelManager.addChannel(channel);
    }

    @Override
    protected void logOnChannelConnected(Channel channel) {
        LogUtil.LogDebug(LOG, "[PadFrameProcessor.logOnChannelConnected] Connection opened [" + channel.getRemoteAddress() + "], Current frame content connection count is : " + String.valueOf(this.channelManager.getChannelCount()));
    }

    @Override
    protected void logOnMessageReceived(Channel channel, Object message) {
        try {
            if (GlobalParam.LOG_MODE != 3) {
                byte[] content = (byte[])message;
                String contentStr = StringUtil.byteToHexString(content);
                LogUtil.LogDebug(LOG, "[PadFrameProcessor.logOnMessageReceived] Received from [ip:" + channel.getRemoteAddress() + "] -- " + contentStr);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(LOG, "[PadFrameProcessor.logOnMessageReceived] Message received from [ip:" + channel.getRemoteAddress() + "] -- " + ex.toString());
        }
        super.logOnMessageReceived(channel, message);
    }

    @Override
    protected void removeChannel(Channel channel) {
        String id = String.valueOf(channel.getId());
        this.channelManager.removeChannel(id);
    }
}

