/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.frameserver;

import com.simba.common.frameserver.netty.OneBFramePipelineFactory;
import com.simba.common.thread.NamedThreadFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;

public class OneBFrameServer {
    protected static Logger logger = Logger.getLogger(OneBFrameServer.class);
    private static final String DEFAULT_ADDRESS = "localhost";
    private static final int DEFAULT_EVENT_THREADS = 16;
    private static final int DEFAULT_IO_THREADS = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_PORT = 8686;
    protected ServerBootstrap bootstrap;
    protected ExecutorService eventExecutor;
    protected InetSocketAddress inetSocketAddress;
    protected final ChannelUpstreamHandler ioHandler;
    private String address = "localhost";
    private int eventThreads = 16;
    private int ioThreads = DEFAULT_IO_THREADS;
    private int port = 8686;

    public OneBFrameServer(String address, int port, int ioThreads, int eventThreads, ChannelUpstreamHandler ioHandler) {
        this.address = address;
        this.port = port;
        this.ioThreads = ioThreads;
        this.eventThreads = eventThreads;
        this.ioHandler = ioHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPortBound() throws IOException {
        String message = "";
        boolean result = false;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(this.getPort(), 100, InetAddress.getByName(this.getAddress().equals("*") ? "0.0.0.0" : this.getAddress()));
            result = false;
        }
        catch (Exception e) {
            message = e.getMessage();
            result = true;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (result) {
            throw new IOException(message);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public int getEventThreads() {
        return this.eventThreads;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSocketAddress;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void start() throws IOException {
        this.checkPortBound();
        ExecutorService bossExecutor = Executors.newCachedThreadPool();
        MemoryAwareThreadPoolExecutor workerExecutor = new MemoryAwareThreadPoolExecutor(this.getIoThreads(), 0L, 0L, 300L, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("worker thread "));
        if (this.eventExecutor == null && this.getEventThreads() > 0) {
            this.eventExecutor = new MemoryAwareThreadPoolExecutor(this.getEventThreads(), 0L, 0L, 300L, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("event thread "));
        }
        this.bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory((Executor)bossExecutor, workerExecutor, this.getIoThreads()));
        this.bootstrap.setPipelineFactory(new OneBFramePipelineFactory(this.eventExecutor, this.ioHandler));
        this.bootstrap.setOption("reuseAddress", true);
        this.bootstrap.setOption("child.reuseAddress", true);
        this.bootstrap.setOption("writeBufferHighWaterMark", 65536);
        this.bootstrap.setOption("writeBufferLowWaterMark", 32768);
        this.bootstrap.setOption("child.tcpNoDelay", true);
        this.bootstrap.setOption("child.sendBufferSize", 65536);
        this.bootstrap.setOption("child.receiveBufferSize", 65536);
        this.inetSocketAddress = new InetSocketAddress(this.getAddress().equals("*") ? "0.0.0.0" : this.getAddress(), this.getPort());
        this.bootstrap.bind(this.inetSocketAddress);
    }

    public void stop() {
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
        }
    }

    private int getPort() {
        return this.port;
    }
}

