/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.frameclient.connection;

import com.simba.common.frameclient.connection.FrameReadBytesDecoder;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class LineEndPipelineFactory
implements ChannelPipelineFactory {
    protected static final int MAX_FRAME_LENGTH = 1024;
    protected final ExecutorService executor;
    protected final ChannelUpstreamHandler handler;

    public static ChannelBuffer[] lineDelimiter() {
        return new ChannelBuffer[]{ChannelBuffers.wrappedBuffer(new byte[]{13, 10})};
    }

    public LineEndPipelineFactory(ExecutorService executor, ChannelUpstreamHandler handler) {
        this.executor = executor;
        this.handler = handler;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("frameLengthDecoder", new DelimiterBasedFrameDecoder(1024, false, LineEndPipelineFactory.lineDelimiter()));
        pipeline.addLast("bytesReadDecoder", new FrameReadBytesDecoder());
        pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
        if (this.executor != null) {
            pipeline.addLast("executor", new ExecutionHandler(this.executor));
        }
        pipeline.addLast("handler", this.handler);
        return pipeline;
    }
}

