/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.printers;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.printers.PrinterClient;
import com.simba.server.printers.PrinterManager;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class PrinterStatusTask
extends Thread {
    private static final int CLEAR_INTERVAL = 86400000;
    private static final int CLEAR_TIME = 18;
    private static final Logger logger = Logger.getLogger(PrinterStatusTask.class);
    private static final int RESEND_INTERVAL = 5000;
    private long lastClearRecordTime;

    public PrinterStatusTask() {
        this.setName("Printers-Machine-Status-Task");
    }

    public void doSendCmd(final PrinterClient printer) {
        PrinterManager.getInstance().runAsyncTask(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        printer.sendSessionStatus();
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof InterruptedException)) break block2;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.sendPrinterStatusSession();
                this.checkNeedClearPrintRecord();
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "[PrinterStatusTask] Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private void checkNeedClearPrintRecord() {
        try {
            Calendar calendar;
            int hour;
            long now = System.currentTimeMillis();
            long delta = now - this.lastClearRecordTime;
            if (delta > 86400000L && (hour = (calendar = Calendar.getInstance()).get(11)) == 18) {
                this.lastClearRecordTime = now;
                ICommand command = CommandCreator.getInstance().createCommand("TruncateTableCmd", "tt_print_pack_record");
                SQLCommandExecutor.getInstance().executeCmd(command);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[PrinterStatusTask.checkNeedClearPrintRecord] Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private void sendPrinterStatusSession() {
        PrinterClient[] clientPrinters;
        for (PrinterClient printer : clientPrinters = PrinterManager.getInstance().getClientPrinterList()) {
            this.doSendCmd(printer);
        }
    }
}

