/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.printers;

import com.simba.common.log.LogUtil;
import com.simba.server.components.PackInfoManager;
import com.simba.server.components.data.PackInfo;
import com.simba.server.printers.PrinterClient;
import com.simba.server.printers.PrinterManager;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class PrinterPackTask
extends Thread {
    private static final Logger logger = Logger.getLogger(PrinterPackTask.class);
    private static final int PRINTER_PACK_INFO_INTERVAL = 2000;
    private PackInfo lastPackInfo;
    private final BlockingQueue<PackInfo> packInfoList = new LinkedBlockingQueue<PackInfo>();
    private final PrinterClient printerClient;
    private final String printerId;

    public PrinterPackTask(PrinterClient client, String printerId) {
        this.printerClient = client;
        this.printerId = printerId;
        this.setName("Printer-Pack-Task-" + this.printerId);
    }

    public PackInfo getLastPackInfo() {
        return this.lastPackInfo;
    }

    public Boolean offerPackInfo(PackInfo packInfo) {
        if (packInfo == null) {
            return false;
        }
        return this.packInfoList.offer(packInfo);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.doPrintPackInfoSession();
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "[PrinterPackTask] Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    public void setLastPackInfo(PackInfo lastPackInfo) {
        this.lastPackInfo = lastPackInfo;
    }

    private void doPrintPackInfoSession() throws InterruptedException {
        if (this.printerClient.isErrorStatus()) {
            Thread.sleep(2000L);
            return;
        }
        PackInfo packInfo = this.takePackInfo();
        if (packInfo != null) {
            this.handlePrintSession(packInfo);
            Thread.sleep(2000L);
        }
    }

    private void handleInSlavePrinter(PackInfo packInfo) {
        String printerIpSlave = packInfo.getPrinterIpSlave();
        if (printerIpSlave.equals(this.printerClient.getServerHost())) {
            PackInfoManager.getInstance().renewPackInfoPrintFailed(packInfo);
            return;
        }
        PrinterClient clientSlave = PrinterManager.getInstance().getClientPrinterByIP(printerIpSlave);
        if (clientSlave != null) {
            clientSlave.offerPackInfoToPrint(packInfo);
        } else {
            PackInfoManager.getInstance().renewPackInfoPrintFailed(packInfo);
        }
    }

    private void handlePrintSession(PackInfo packInfo) {
        this.lastPackInfo = packInfo;
        byte[] cmdBuf = packInfo.getPrintCmd();
        if (cmdBuf != null && cmdBuf.length > 0) {
            int status = this.printerClient.sendSessionPackInfo(cmdBuf, packInfo);
            if (status == 0) {
                packInfo.setPrinterAddress(this.printerClient.getServerHost());
                PackInfoManager.getInstance().recordPrintPackInfo(packInfo);
            } else if (status == 1) {
                PackInfoManager.getInstance().renewPackInfoPrintFailed(packInfo);
            } else if (status == 2) {
                this.handleInSlavePrinter(packInfo);
            }
        } else {
            PackInfoManager.getInstance().renewPackInfoPrintFailed(packInfo);
        }
    }

    private PackInfo takePackInfo() throws InterruptedException {
        PackInfo packInfo = null;
        packInfo = this.packInfoList.take();
        return packInfo;
    }
}

