/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.printercmd;

import com.simba.common.log.LogUtil;
import com.simba.server.components.data.PackInfo;
import com.simba.server.printercmd.PrinterCmdUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class PackZebraCmdCreator {
    private static final Logger logger = Logger.getLogger(PackZebraCmdCreator.class);
    private static PackZebraCmdCreator instance = new PackZebraCmdCreator();

    public static PackZebraCmdCreator getInstance() {
        return instance;
    }

    private PackZebraCmdCreator() {
    }

    public byte[] createPackCmd(PackInfo packInfo) {
        byte[] cmdBuffer = null;
        PrinterCmdUtils.getInstance().preHandlePacketInfo(packInfo);
        try {
            String cmd = "^XA";
            cmd = cmd + "^CW1,E:SIMSUN.FNT^FS";
            cmd = cmd + "^CI28";
            String boxType = packInfo.getBoxType();
            if (boxType.equals("1")) {
                cmd = cmd + "^FO100,100^BY4^BCN,300,Y,N,N^FD" + packInfo.getBarcode() + "^FS";
                cmd = cmd + "^FO300,500^A1N150,150^FD\u683c\u53e3:^FS";
                cmd = cmd + "^FO720,500^A1N150,150^FD" + packInfo.getSlotId() + "^FS";
                cmd = cmd + "^FO300,800^A1N150,150^FD\u7968\u6570:^FS";
                cmd = cmd + "^FO720,800^A1N150,150^FD" + packInfo.getPackCounts() + "^FS";
            } else {
                cmd = cmd + "^FO300,100^A1N100,100^FD\u683c\u53e3\u53f7:^FS";
                cmd = cmd + "^FO700,100^A1N100,100^FD" + packInfo.getSlotId() + "^FS";
                String message = packInfo.getMessage();
                message = message.equals("") || message.equals("none") ? "" : "\u6253\u5370\u4fe1\u606f:" + message;
                int messageLen = this.getMessageLength(message);
                String[] messageList = this.handlerMessageToList(message);
                if (messageLen <= 180) {
                    cmd = cmd + this.handlerMessage(messageList);
                } else {
                    LogUtil.LogDebug(logger, "[PackZebraCmdCreator.createPackCmd] messageList Length error: " + message);
                }
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String strTimeString = df.format(new Date());
            cmd = cmd + "^FO100,1100^A1N70,70^FD\u6253\u5370\u65f6\u95f4:" + strTimeString + "^FS";
            cmd = cmd + "^XZ";
            cmdBuffer = cmd.getBytes();
        }
        catch (Exception ex) {
            cmdBuffer = null;
        }
        return cmdBuffer;
    }

    private String handlerMessage(String[] messageList) {
        String ret = "";
        int routeNameLen = messageList.length;
        int[] positionX = new int[]{80, 80, 80, 80, 80, 80, 80};
        int[] positionY = new int[]{300, 400, 500, 600, 700, 800};
        for (int i = 0; i < routeNameLen && !messageList[i].equals(""); ++i) {
            ret = ret + "^FO" + positionX[i] + "," + positionY[i] + "^A1N70,70^FD" + messageList[i] + "^FS";
        }
        return ret;
    }

    private String[] handlerMessageToList(String message) {
        String[] messageList = new String[]{"", "", "", "", "", ""};
        int strLen = 0;
        for (int i = 0; i < message.length(); ++i) {
            int intPosition;
            String messageCache = message.substring(i, i + 1);
            int messageCacheLen = this.getMessageLength(messageCache);
            int n = intPosition = this.getMessageListPosition(strLen += messageCacheLen);
            messageList[n] = messageList[n] + messageCache;
        }
        return messageList;
    }

    private int getMessageLength(String value) {
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    private int getMessageListPosition(int strLen) {
        int ret = strLen / 30;
        return ret;
    }
}

