/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder;

import com.simba.common.RequestHandler;
import com.simba.common.decoder.Decoder;
import com.simba.common.decoder.DecoderContainer;
import com.simba.common.decoder.DefaultDecoderContainer;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.CommonDefines;
import com.simba.server.framedecoder.decoders.EchoTimeDecoder;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class DecoderManager
implements RequestHandler {
    protected static final Logger logger = Logger.getLogger(DecoderManager.class);
    private final DecoderContainer decoderContainer = new DefaultDecoderContainer();

    public static DecoderManager getInstance() {
        return FrameDecoderManagerHolder.INSTANCE;
    }

    private DecoderManager() {
    }

    @Override
    public void handleRequest(final Channel channel, final Object message) {
        Runnable executeRunnable = new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        if (!(message instanceof byte[])) {
                            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[FrameDecoderManager.handleRequest] Message is not instance of byte[].", 1));
                            FrameChannelManager.getInstance().commitResponse(channel, CommonDefines.ERROR_MESSAGE, true);
                            return;
                        }
                        byte[] content = (byte[])message;
                        byte command = content[2];
                        Decoder frameDecoder = DecoderManager.this.getDecoderByCommandNum(command);
                        if (frameDecoder != null) {
                            frameDecoder.doDecode(channel, message);
                        }
                    }
                    catch (Exception ex) {
                        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[FrameDecoderManager.handleRequest] catch exception : " + ex.getMessage(), 2));
                        if (!(ex instanceof InterruptedException)) break block4;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.executeInNewThread(executeRunnable);
    }

    public void init() {
        this.initDecoderContainer();
    }

    public void postInitProcess() {
        String requestMode = "Request In New Thread";
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[FrameDecoderManager.postInitProcess] Initialize successfully,] reqeust mode:[" + requestMode + "]", 3));
    }

    protected Decoder getDecoderByCommandNum(byte command) {
        Decoder frameDecoder = null;
        switch (command) {
            case -2: {
                frameDecoder = this.decoderContainer.getDecoder("none");
                break;
            }
            case 17: {
                frameDecoder = this.decoderContainer.getDecoder("EchoTime");
                break;
            }
        }
        return frameDecoder;
    }

    private void executeInNewThread(Runnable executeRunnable) {
        new Thread(executeRunnable).start();
    }

    private void initDecoderContainer() {
        this.decoderContainer.addDecoder("EchoTime", EchoTimeDecoder.getInstance());
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onChannelDisconnected(Channel channel) {
    }

    private static class FrameDecoderManagerHolder {
        private static final DecoderManager INSTANCE = new DecoderManager();

        private FrameDecoderManagerHolder() {
        }
    }
}

