/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PackInfoManager;
import com.simba.server.components.data.PackInfo;
import com.simba.server.printercmd.PackCmdCreator;
import com.simba.server.printercmd.PackZebraCmdCreator;
import com.simba.server.printers.PrinterManager;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class PackInfoLoadTask
extends Thread {
    private static final Logger logger = Logger.getLogger(PackInfoLoadTask.class);
    protected int packInfoId;

    public PackInfoLoadTask() {
        this.setName("Pack-Info-Load-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.doFetchPackInfo();
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "[PackInfoLoadTask] Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private void doFetchPackInfo() throws InterruptedException {
        LinkedList packInfos = new LinkedList();
        ICommand command = CommandCreator.getInstance().createCommand("FetchPacknfosCmd", packInfos);
        SQLCommandExecutor.getInstance().executeCmd(command);
        if (packInfos != null && packInfos.size() > 0) {
            for (PackInfo item : packInfos) {
                this.packInfoId = item.getId();
                ICommand renewCommand = CommandCreator.getInstance().createCommand("RenewPackInfoSuccessCmd", item);
                SQLCommandExecutor.getInstance().executeCmd(renewCommand);
                this.requestPrinterCmdLocal(item);
            }
        } else {
            Thread.sleep(2000L);
        }
        Thread.sleep(1000L);
    }

    private void requestPrinterCmdLocal(PackInfo packInfo) {
        String PrinterType;
        byte[] cmd = null;
        switch (PrinterType = PrinterManager.getInstance().getPrinterType()) {
            case "Toshiba": {
                cmd = PackCmdCreator.getInstance().createPackCmd(packInfo);
                break;
            }
            case "Zebra": {
                cmd = PackZebraCmdCreator.getInstance().createPackCmd(packInfo);
            }
        }
        packInfo.setPrintCmd(cmd);
        PackInfoManager.getInstance().sendPackInfoToPrinter(packInfo);
    }
}

