/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server;

import com.simba.common.command.CommandParams;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.database.DbPool;
import com.simba.common.database.DbPoolInterface;
import com.simba.common.frameserver.FrameChannelHandler;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.frameserver.TwoBFrameServer;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogHelper;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.processor.FrameProcessor;
import com.simba.server.ServerParam;
import com.simba.server.components.PackInfoManager;
import com.simba.server.framedecoder.DecoderManager;
import com.simba.server.printers.PrinterManager;
import java.io.File;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderSAX2Factory;

public class ServerManager {
    private static ServerManager instance = new ServerManager();
    private static final String LOG4J_CONFIG_FILE_DEBUG = "simba-log4j-debug.xml";
    private static final String LOG4J_CONFIG_FILE_VERBOSE = "simba-log4j-verbose.xml";
    private static final Logger logger = Logger.getLogger(ServerManager.class);
    private static final String MYSQL_CONFIG_FILE = "simba-mysql-config.xml";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private TwoBFrameServer frameServer;
    private final DbPoolInterface mysqlDbPool = new DbPool("simba-mysql-config.xml", "mysql");
    private String runMode;
    private int serialNumber;

    public static ServerManager getInstance() {
        return instance;
    }

    private ServerManager() {
    }

    public SimpleDateFormat getDateformat() {
        return this.dateFormat;
    }

    public TwoBFrameServer getFrameServer() {
        return this.frameServer;
    }

    public DbPoolInterface getMysqlDbPool() {
        return this.mysqlDbPool;
    }

    public String getRunMode() {
        return this.runMode;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXmlDocFromFile(File fp) throws Exception {
        Document xmlDoc = null;
        try {
            SAXBuilder builder = null;
            String driver = "org.apache.crimson.parser.XMLReaderImpl";
            builder = new SAXBuilder(new XMLReaderSAX2Factory(false, driver));
            xmlDoc = builder.build(fp);
        }
        catch (Exception ex) {
            if (xmlDoc == null) {
                throw ex;
            }
        }
        return xmlDoc;
    }

    public void init() {
        this.initParam();
        this.initDatabase();
        this.initServerInstance();
        this.buildAllServers();
        this.startSingleThreadTasks();
        ServerParam.printStartedInfo();
        this.postInitProcess();
    }

    public void setFrameServer(TwoBFrameServer frameServer) {
        this.frameServer = frameServer;
    }

    public void setRunMode(String runMode) {
        this.runMode = runMode;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    protected void buildAllServers() {
        this.buildFrameServer();
    }

    protected void initDbPool() {
        this.getMysqlDbPool().init(true);
        SQLCommandExecutor.getInstance().setDbPool(this.mysqlDbPool);
    }

    protected void initParam() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        if (this.getRunMode().equals("debug")) {
            ServerParam.initRootLogger(LOG4J_CONFIG_FILE_DEBUG);
        } else {
            ServerParam.initRootLogger(LOG4J_CONFIG_FILE_VERBOSE);
        }
        ServerParam.initGlobalConfiguration();
    }

    private void buildFrameServer() {
        System.out.println("\u3010Server Init\u3011 Starting the tcp server of frame message ...");
        try {
            FrameProcessor frameMessageProcessor = new FrameProcessor(DecoderManager.getInstance(), FrameChannelManager.getInstance());
            FrameChannelHandler handler = new FrameChannelHandler(frameMessageProcessor);
            this.setFrameServer(new TwoBFrameServer(ServerParam.getServerInfo().getDefaultServerAddress(), ServerParam.getServerInfo().getDefaultServerPort(), ServerParam.IO_THREAD_POOL_SIZE, ServerParam.EVENT_THREAD_POOL_SIZE, handler));
            this.getFrameServer().start();
            String printInfo = "\u3010Server Init\u3011Starting the frame sorter server on: " + this.getFrameServer().getInetSocketAddress().toString();
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), printInfo, 1));
            System.out.println(printInfo);
        }
        catch (Exception e) {
            LogHelper.error(e.toString());
        }
    }

    private void initCommandParams() {
        CommandParams.getInstance().init();
    }

    private void initDatabase() {
        this.initDbPool();
    }

    private void initPackInfoManager() {
        PackInfoManager.getInstance().init();
    }

    private void initPrinterManager() {
        PrinterManager.getInstance().init();
    }

    private void initServerInstance() {
        this.initPrinterManager();
        this.initPackInfoManager();
        this.initCommandParams();
    }

    private void postInitProcess() {
    }

    private void startSingleThreadTasks() {
    }
}

