/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.log;

import com.simba.GlobalParam;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogHelper {
    private static Logger logger = Logger.getLogger(LogHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(String configFilePath, String verboseLogPath, String accessLogPath, String errorLogPath) {
        InputStreamReader fileReader = null;
        BufferedReader bufferedFileReader = null;
        try {
            File configFile = new File("etc" + GlobalParam.PATH_SEP + configFilePath);
            fileReader = new FileReader(configFile);
            bufferedFileReader = new BufferedReader(fileReader);
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = bufferedFileReader.readLine()) != null) {
                sb.append(line + "\n");
            }
            String content = sb.toString();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
            Document doc = builder.parse(inputStream);
            Element e = doc.getDocumentElement();
            DOMConfigurator.configure(e);
        }
        catch (Exception ex) {
            System.out.println("[LogHelper.configure] : configure Log4j Error");
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedFileReader != null) {
                try {
                    bufferedFileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void debug(Object message) {
        LogHelper.write(3, message);
    }

    public static void error(Object message) {
        LogHelper.write(2, message);
    }

    public static void fatal(Object message) {
        LogHelper.write(2, message);
    }

    public static void info(Object message) {
        LogHelper.write(1, message);
    }

    public static void trace(Object message) {
        LogHelper.write(3, message);
    }

    public static void warn(Object message) {
        LogHelper.write(0, message);
    }

    private static void write(int level, Object message) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), message, level));
    }
}

