/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.frameserver.netty;

import com.simba.common.frameserver.netty.FrameReadBytesDecoder;
import com.simba.common.frameserver.netty.OctBFrameDecoder;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class OctBFramePipelineFactory
implements ChannelPipelineFactory {
    protected static final int MAX_FRAME_LENGTH = 65535;
    private static final int LENGTH_FIELD_OFFSET = 0;
    private static final int LENGTH_FIELD_SIZE = 8;
    protected final ExecutorService executor;
    protected final ChannelUpstreamHandler handler;

    public OctBFramePipelineFactory(ExecutorService executor, ChannelUpstreamHandler handler) {
        this.executor = executor;
        this.handler = handler;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("frameLengthDecoder", new OctBFrameDecoder(65535, 0, 8, 0, 8));
        pipeline.addLast("bytesReadDecoder", new FrameReadBytesDecoder());
        pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
        if (this.executor != null) {
            pipeline.addLast("executor", new ExecutionHandler(this.executor));
        }
        pipeline.addLast("handler", this.handler);
        return pipeline;
    }
}

