/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.frameclient.connection;

import com.simba.common.frameclient.connection.NettyEndPoint;
import com.simba.common.frameclient.connection.NettyEventHandler;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.timeout.IdleState;

public class NettyConnection
implements NettyEndPoint {
    public static final String CHANNEL_CONNECT = "0";
    public static final String CHANNEL_DISCONNECT = "1";
    protected static final Logger logger = Logger.getLogger(NettyConnection.class);
    private final ClientBootstrap bootstrap;
    private final AtomicBoolean doConnecting = new AtomicBoolean(false);
    private final NettyEventHandler eventHandler;
    private final String serverHost;
    private final int serverPort;
    private Channel singleChannel;

    public NettyConnection(String host, int port, NettyEventHandler eventHandler, ClientBootstrap bootstrap) {
        this.serverHost = host;
        this.serverPort = port;
        this.eventHandler = eventHandler;
        this.bootstrap = bootstrap;
    }

    @Override
    public void channelExceptionCaught(Channel channel, Throwable cause) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception when receive message from netty client : exception--" + cause.toString(), 2));
    }

    @Override
    public void channelIdleState(Channel channel, IdleState state) {
    }

    @Override
    public void channelStateChanged(String channelConnect, Channel channel) {
        if (channel != this.singleChannel) {
            return;
        }
        if (CHANNEL_DISCONNECT.equalsIgnoreCase(channelConnect)) {
            this.fireClose();
        }
        if (CHANNEL_CONNECT.equalsIgnoreCase(channelConnect)) {
            // empty if block
        }
    }

    public synchronized void disconnect() {
        if (this.singleChannel != null) {
            this.singleChannel.disconnect();
            this.singleChannel = null;
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.singleChannel.getRemoteAddress();
    }

    public boolean isChannelConnected() {
        return this.singleChannel != null && this.singleChannel.isConnected();
    }

    @Override
    public void messageRecived(Channel channel, Object message) {
        if (message instanceof byte[]) {
            byte[] content = (byte[])message;
            this.fireMessageReceived(channel, content);
        } else if (message instanceof String) {
            String content = (String)message;
            this.fireMessageReceived(channel, content);
        }
    }

    @Override
    public void onChannelClosed(Channel channel) {
    }

    @Override
    public void onChannelConnected(Channel channel) {
        try {
            this.eventHandler.onChannelConnected(channel);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }

    public void send(Object messageObj, Boolean close) {
        if (messageObj == null && !this.isChannelConnected()) {
            this.doConnect();
            return;
        }
        if (this.isChannelConnected()) {
            if (messageObj == null) {
                return;
            }
            this.doWrite(messageObj, close);
        } else {
            this.doConnect();
        }
    }

    protected boolean isNeedClose(Object response, boolean close) {
        return close;
    }

    private synchronized void doConnect() {
        try {
            if (this.isChannelConnected() || this.doConnecting.get()) {
                return;
            }
            this.doConnecting.set(true);
            ChannelFuture chFuture = this.bootstrap.connect(new InetSocketAddress(this.serverHost, this.serverPort));
            chFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    NettyConnection.this.doConnecting.set(false);
                    Channel ch = future.getChannel();
                    if (ch != null && ch.isConnected()) {
                        ch.setAttachment(NettyConnection.this);
                        NettyConnection.this.singleChannel = ch;
                        NettyConnection.this.fireConnected();
                    } else {
                        NettyConnection.this.fireConnectFailed();
                    }
                }
            });
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception when receive connect to channel : exception--" + ex.getMessage(), 2));
        }
    }

    private ChannelFuture doWrite(Object contentObj, Boolean close) {
        ChannelFuture writeFuture = null;
        try {
            if (!(contentObj instanceof byte[])) {
                return writeFuture;
            }
            byte[] content = (byte[])contentObj;
            int limit = content.length;
            ByteBuffer returnBuffer = ByteBuffer.allocate(limit);
            returnBuffer.put(content, 0, limit);
            returnBuffer.rewind();
            ChannelBuffer duplicateBuffer = ChannelBuffers.wrappedBuffer(returnBuffer);
            writeFuture = this.singleChannel.write(duplicateBuffer);
            if (this.isNeedClose(contentObj, close)) {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
            return writeFuture;
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            writeFuture = null;
            return writeFuture;
        }
    }

    private void fireClose() {
        try {
            this.eventHandler.onConnectionClosed();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }

    private void fireConnected() {
        try {
            this.eventHandler.onConnectionOpen();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }

    private void fireConnectFailed() {
        try {
            this.eventHandler.onConnectFailed();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }

    private void fireMessageReceived(Channel channel, Object message) {
        try {
            this.eventHandler.messageReceived(channel, message);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }
}

