/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.frameclient;

import com.simba.common.frameclient.IBootstrapManager;
import com.simba.common.frameclient.IClient;
import com.simba.common.frameclient.connection.NettyConnection;
import com.simba.common.frameclient.connection.NettyEventHandler;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;

public abstract class BaseClient
implements IClient,
NettyEventHandler {
    protected static final Logger logger = Logger.getLogger(BaseClient.class);
    protected IBootstrapManager bootstrapManager;
    protected NettyConnection connection;
    protected String id;
    protected AtomicBoolean isInited = new AtomicBoolean(false);
    protected String name;
    protected String serverHost;
    protected int serverPort;

    @Override
    public void disconnect() {
        if (this.isConnected().booleanValue()) {
            this.connection.disconnect();
        }
    }

    @Override
    public void doReconnected() {
        this.connection.send(null, false);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean isConnected() {
        return this.connection != null && this.connection.isChannelConnected();
    }

    @Override
    public void onChannelClosed(Channel channel) {
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onConnectFailed() {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[BaseClient.onConnectFailed] Connected to server--[HOST:" + this.serverHost + "][PORT:" + this.serverPort + "] Failed", 2));
    }

    @Override
    public void onConnectionClosed() {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[BaseClient.onConnectionClosed] Close from server--[HOST:" + this.serverHost + "][PORT:" + this.serverPort + "]", 2));
    }

    @Override
    public void onConnectionOpen() {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[BaseClient.onConnectionOpen] Connected to server--[HOST:" + this.serverHost + "][PORT:" + this.serverPort + "]", 3));
    }

    @Override
    public void start(String clientId, String serverHost, int serverPort, String clientName, IBootstrapManager bootstrapManager) {
        this.id = clientId;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.name = clientName;
        this.bootstrapManager = bootstrapManager;
        if (this.isInited()) {
            return;
        }
        this.init();
    }

    private void init() {
        if (this.isInited()) {
            return;
        }
        this.setInited(true);
        ClientBootstrap bootstrap = this.bootstrapManager.getClientBootstrap(this.name);
        if (bootstrap == null) {
            return;
        }
        this.connection = new NettyConnection(this.serverHost, this.serverPort, this, bootstrap);
    }

    private boolean isInited() {
        return this.isInited.get();
    }

    private void setInited(boolean res) {
        this.isInited.set(res);
    }
}

