/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.database;

import com.simba.common.database.DatabaseParamsBase;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import java.io.File;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class OraclePoolParams
extends DatabaseParamsBase {
    private static final Logger logger = Logger.getLogger(OraclePoolParams.class);

    @Override
    public void init(String configFilePath) {
        try {
            Document rootDoc = this.getXmlDocFromFile(new File(configFilePath));
            Element root = rootDoc.getRootElement();
            Element rootElement = root.getChild("Oracle");
            String mode = rootElement.getAttribute("mode").getValue();
            String jdbcURL = "";
            String aliasPrefix = rootElement.getChild("alias-prefix").getText();
            this.setAliasPrefix(aliasPrefix);
            String databaseUser = rootElement.getChild("database-user").getText();
            this.setDatabaseUser(databaseUser);
            String databasePassword = rootElement.getChild("database-password").getText();
            this.setDatabasePassword(databasePassword);
            String databaseHouseKeepingSql = rootElement.getChild("database-house-keeping").getText();
            this.setHouseKeepingTestSql(databaseHouseKeepingSql);
            String alias = this.getAliasPrefix() + UUID.randomUUID().toString();
            this.setAlias(alias);
            if (mode.equalsIgnoreCase("thin")) {
                Element thinMessage = rootElement.getChild("thin");
                String databaseHost = thinMessage.getChild("database-host").getText();
                this.setDatabaseHost(databaseHost);
                String databasePort = thinMessage.getChild("database-port").getText();
                this.setDatabasePort(Integer.parseInt(databasePort));
                String databaseSid = thinMessage.getChild("database-sid").getText();
                this.setDatabaseSid(databaseSid);
                jdbcURL = "jdbc:oracle:thin:@" + databaseHost + ":" + databasePort + ":" + databaseSid;
            } else if (mode.equalsIgnoreCase("oci")) {
                Element ociElement = rootElement.getChild("oci");
                String serviceName = ociElement.getChild("service-name").getText();
                jdbcURL = "jdbc:oracle:oci8:@" + serviceName;
            }
            this.setJdbcURL(jdbcURL);
            this.setJdbcDriver("oracle.jdbc.driver.OracleDriver");
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Init Oracle Parameters Error -- Exception : " + ex, 2));
        }
    }
}

