/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.database;

import com.simba.common.database.DatabaseParamsBase;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import java.io.File;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class MysqlPoolParams
extends DatabaseParamsBase {
    private static final Logger logger = Logger.getLogger(MysqlPoolParams.class);

    @Override
    public void init(String configFilePath) {
        try {
            Document rootDoc = this.getXmlDocFromFile(new File(configFilePath));
            Element root = rootDoc.getRootElement();
            Element rootElement = root.getChild("Mysql");
            String aliasPrefix = rootElement.getChild("alias-prefix").getText();
            this.setAliasPrefix(aliasPrefix);
            String databaseAddress = rootElement.getChild("database-address").getText();
            this.setDatabaseAddress(databaseAddress);
            String databaseHost = rootElement.getChild("database-host").getText();
            this.setDatabaseHost(databaseHost);
            String databaseName = rootElement.getChild("database-name").getText();
            this.setDatabaseName(databaseName);
            String databasePassword = rootElement.getChild("database-password").getText();
            this.setDatabasePassword(databasePassword);
            String databaseHouseKeepingSql = rootElement.getChild("database-house-keeping").getText();
            this.setHouseKeepingTestSql(databaseHouseKeepingSql);
            int databasePort = Integer.parseInt(rootElement.getChild("database-port").getText());
            this.setDatabasePort(databasePort);
            String databaseUser = rootElement.getChild("database-user").getText();
            this.setDatabaseUser(databaseUser);
            String alias = this.getAliasPrefix() + UUID.randomUUID().toString();
            this.setAlias(alias);
            this.setJdbcDriver("com.mysql.jdbc.Driver");
            this.setJdbcURL("jdbc:mysql://" + this.getDatabaseHost() + "/" + this.getDatabaseName() + "?autoReconnect=true&useUnicode=true&characterEncoding=utf-8&connectTimeout=5000&socketTimeout=5000");
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Init MySQL Parameters Error -- Exception : " + ex, 2));
        }
    }
}

